"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * Wraps the headers to match those used by fetch APIs.
 * @internal
 */
class HeaderWrapper {
    constructor(headers) {
        this._headers = headers;
    }
    _headerVal(name) {
        const val = this._headers[name];
        if (val === undefined || val === null) {
            return null;
        }
        if (Array.isArray(val)) {
            return val.join(', ');
        }
        return val;
    }
    get(name) {
        return this._headerVal(name);
    }
    keys() {
        return Object.keys(this._headers);
    }
    // We want to use generators here for the simplicity of maintaining
    // this interface. Also they aren't expected to be high frequency usage.
    *values() {
        // eslint-disable-next-line no-restricted-syntax
        for (const key of this.keys()) {
            const val = this.get(key);
            if (val !== null) {
                yield val;
            }
        }
    }
    *entries() {
        // eslint-disable-next-line no-restricted-syntax
        for (const key of this.keys()) {
            const val = this.get(key);
            if (val !== null) {
                yield [key, val];
            }
        }
    }
    has(name) {
        return Object.prototype.hasOwnProperty.call(this._headers, name);
    }
}
exports.default = HeaderWrapper;
//# sourceMappingURL=HeaderWrapper.js.map