"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const events_1 = require("events");
const Emits_1 = require("./Emits");
/**
 * @ignore
 */
class BigSegmentStoreStatusProviderNode {
    constructor(_provider) {
        this._provider = _provider;
        this.emitter = new events_1.EventEmitter();
        this._provider.setListener((status) => {
            this.dispatch('change', status);
        });
    }
    getStatus() {
        return this._provider.getStatus();
    }
    requireStatus() {
        return this._provider.requireStatus();
    }
    dispatch(eventType, status) {
        this.emitter.emit(eventType, status);
    }
    on(event, listener) {
        this.emitter.on(event, listener);
        return this;
    }
}
exports.default = (0, Emits_1.Emits)(BigSegmentStoreStatusProviderNode);
//# sourceMappingURL=BigSegmentsStoreStatusProviderNode.js.map