"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const LruCache_1 = require("../cache/LruCache");
class ContextDeduplicator {
    constructor(options) {
        this._contextKeysCache = new LruCache_1.default({ max: options.contextKeysCapacity });
        this.flushInterval = options.contextKeysFlushInterval;
    }
    processContext(context) {
        const { canonicalKey } = context;
        const inCache = this._contextKeysCache.get(canonicalKey);
        this._contextKeysCache.set(canonicalKey, true);
        // If it is in the cache, then we do not want to add an event.
        return !inCache;
    }
    flush() {
        this._contextKeysCache.clear();
    }
}
exports.default = ContextDeduplicator;
//# sourceMappingURL=ContextDeduplicator.js.map