"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getSubgraphsSeenSet = exports.RemoteException = exports.UnreachableNodeError = exports.MultipleSubgraphsError = exports.InvalidUpdateError = exports.EmptyChannelError = exports.EmptyInputError = exports.ParentCommand = exports.NodeInterrupt = exports.GraphInterrupt = exports.GraphValueError = exports.GraphRecursionError = exports.GraphBubbleUp = exports.BaseLangGraphError = void 0;
exports.isParentCommand = isParentCommand;
exports.isGraphBubbleUp = isGraphBubbleUp;
exports.isGraphInterrupt = isGraphInterrupt;
// TODO: Merge with base LangChain error class when we drop support for core@0.2.0
class BaseLangGraphError extends Error {
    constructor(message, fields) {
        let finalMessage = message ?? "";
        if (fields?.lc_error_code) {
            finalMessage = `${finalMessage}\n\nTroubleshooting URL: https://langchain-ai.github.io/langgraphjs/troubleshooting/errors/${fields.lc_error_code}/\n`;
        }
        super(finalMessage);
        Object.defineProperty(this, "lc_error_code", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: void 0
        });
        this.lc_error_code = fields?.lc_error_code;
    }
}
exports.BaseLangGraphError = BaseLangGraphError;
class GraphBubbleUp extends BaseLangGraphError {
    get is_bubble_up() {
        return true;
    }
}
exports.GraphBubbleUp = GraphBubbleUp;
class GraphRecursionError extends BaseLangGraphError {
    constructor(message, fields) {
        super(message, fields);
        this.name = "GraphRecursionError";
    }
    static get unminifiable_name() {
        return "GraphRecursionError";
    }
}
exports.GraphRecursionError = GraphRecursionError;
class GraphValueError extends BaseLangGraphError {
    constructor(message, fields) {
        super(message, fields);
        this.name = "GraphValueError";
    }
    static get unminifiable_name() {
        return "GraphValueError";
    }
}
exports.GraphValueError = GraphValueError;
class GraphInterrupt extends GraphBubbleUp {
    constructor(interrupts, fields) {
        super(JSON.stringify(interrupts, null, 2), fields);
        Object.defineProperty(this, "interrupts", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: void 0
        });
        this.name = "GraphInterrupt";
        this.interrupts = interrupts ?? [];
    }
    static get unminifiable_name() {
        return "GraphInterrupt";
    }
}
exports.GraphInterrupt = GraphInterrupt;
/** Raised by a node to interrupt execution. */
class NodeInterrupt extends GraphInterrupt {
    // eslint-disable-next-line @typescript-eslint/no-explicit-any
    constructor(message, fields) {
        super([
            {
                value: message,
                when: "during",
            },
        ], fields);
        this.name = "NodeInterrupt";
    }
    static get unminifiable_name() {
        return "NodeInterrupt";
    }
}
exports.NodeInterrupt = NodeInterrupt;
class ParentCommand extends GraphBubbleUp {
    constructor(command) {
        super();
        Object.defineProperty(this, "command", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: void 0
        });
        this.name = "ParentCommand";
        this.command = command;
    }
    static get unminifiable_name() {
        return "ParentCommand";
    }
}
exports.ParentCommand = ParentCommand;
function isParentCommand(e) {
    return (e !== undefined &&
        e.name === ParentCommand.unminifiable_name);
}
function isGraphBubbleUp(e) {
    return e !== undefined && e.is_bubble_up === true;
}
function isGraphInterrupt(e) {
    return (e !== undefined &&
        [
            GraphInterrupt.unminifiable_name,
            NodeInterrupt.unminifiable_name,
        ].includes(e.name));
}
class EmptyInputError extends BaseLangGraphError {
    constructor(message, fields) {
        super(message, fields);
        this.name = "EmptyInputError";
    }
    static get unminifiable_name() {
        return "EmptyInputError";
    }
}
exports.EmptyInputError = EmptyInputError;
class EmptyChannelError extends BaseLangGraphError {
    constructor(message, fields) {
        super(message, fields);
        this.name = "EmptyChannelError";
    }
    static get unminifiable_name() {
        return "EmptyChannelError";
    }
}
exports.EmptyChannelError = EmptyChannelError;
class InvalidUpdateError extends BaseLangGraphError {
    constructor(message, fields) {
        super(message, fields);
        this.name = "InvalidUpdateError";
    }
    static get unminifiable_name() {
        return "InvalidUpdateError";
    }
}
exports.InvalidUpdateError = InvalidUpdateError;
/**
 * @deprecated This exception type is no longer thrown.
 */
class MultipleSubgraphsError extends BaseLangGraphError {
    constructor(message, fields) {
        super(message, fields);
        this.name = "MultipleSubgraphError";
    }
    static get unminifiable_name() {
        return "MultipleSubgraphError";
    }
}
exports.MultipleSubgraphsError = MultipleSubgraphsError;
class UnreachableNodeError extends BaseLangGraphError {
    constructor(message, fields) {
        super(message, fields);
        this.name = "UnreachableNodeError";
    }
    static get unminifiable_name() {
        return "UnreachableNodeError";
    }
}
exports.UnreachableNodeError = UnreachableNodeError;
/**
 * Exception raised when an error occurs in the remote graph.
 */
class RemoteException extends BaseLangGraphError {
    constructor(message, fields) {
        super(message, fields);
        this.name = "RemoteException";
    }
    static get unminifiable_name() {
        return "RemoteException";
    }
}
exports.RemoteException = RemoteException;
/**
 * Used for subgraph detection.
 */
const getSubgraphsSeenSet = () => {
    if (
    // eslint-disable-next-line @typescript-eslint/no-explicit-any
    globalThis[Symbol.for("LG_CHECKPOINT_SEEN_NS_SET")] === undefined) {
        // eslint-disable-next-line @typescript-eslint/no-explicit-any
        globalThis[Symbol.for("LG_CHECKPOINT_SEEN_NS_SET")] = new Set();
    }
    // eslint-disable-next-line @typescript-eslint/no-explicit-any
    return globalThis[Symbol.for("LG_CHECKPOINT_SEEN_NS_SET")];
};
exports.getSubgraphsSeenSet = getSubgraphsSeenSet;
//# sourceMappingURL=errors.js.map