"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WatchEditPage = void 0;
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _constants = require("../../../../common/constants");
var _components = require("../../components");
var _api = require("../../lib/api");
var _breadcrumbs = require("../../lib/breadcrumbs");
var _app_context = require("../../app_context");
var _watch = require("../../models/watch");
var _shared_imports = require("../../shared_imports");
var _watch_context = require("./watch_context");
var _components2 = require("./components");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getTitle = watch => {
  if (watch.isNew) {
    const typeName = watch.typeName.toLowerCase();
    return _i18n.i18n.translate('xpack.watcher.sections.watchEdit.json.titlePanel.createNewTypeOfWatchTitle', {
      defaultMessage: 'Create {typeName}',
      values: {
        typeName
      }
    });
  } else {
    return _i18n.i18n.translate('xpack.watcher.sections.watchEdit.json.titlePanel.editWatchTitle', {
      defaultMessage: 'Edit {watchName}',
      values: {
        watchName: watch.name ? watch.name : watch.id
      }
    });
  }
};
const watchReducer = (state, action) => {
  const {
    command,
    payload
  } = action;
  const {
    watch
  } = state;
  const watchTypes = _watch.Watch.getWatchTypes();
  const WatchType = watch && (0, _lodash.has)(watchTypes, watch.type) && (0, _lodash.isFunction)(watchTypes[watch.type]) ? watchTypes[watch.type] : null;
  switch (command) {
    case 'setWatch':
      return {
        ...state,
        watch: payload
      };
    case 'setProperty':
      const {
        property,
        value
      } = payload;
      if ((0, _lodash.isEqual)(watch[property], value)) {
        return state;
      } else {
        if (WatchType) {
          return {
            ...state,
            watch: new WatchType({
              ...watch,
              [property]: value
            })
          };
        }
        return state;
      }
    case 'addAction':
      const {
        type,
        defaults
      } = payload;
      if (WatchType) {
        const newWatch = new WatchType(watch);
        newWatch.createAction(type, defaults);
        return {
          ...state,
          watch: newWatch
        };
      } else {
        return state;
      }
    case 'setError':
      return {
        ...state,
        loadError: payload
      };
  }
};
const WatchEditPage = ({
  match: {
    params: {
      id,
      type
    }
  }
}) => {
  // hooks
  const {
    setBreadcrumbs
  } = (0, _app_context.useAppContext)();
  const [{
    watch,
    loadError
  }, dispatch] = (0, _react.useReducer)(watchReducer, {
    watch: null
  });
  const setWatchProperty = (property, value) => {
    dispatch({
      command: 'setProperty',
      payload: {
        property,
        value
      }
    });
  };
  const addAction = action => {
    dispatch({
      command: 'addAction',
      payload: action
    });
  };
  (0, _react.useEffect)(() => {
    const getWatch = async () => {
      if (id) {
        try {
          const loadedWatch = await (0, _api.loadWatch)(id);
          dispatch({
            command: 'setWatch',
            payload: loadedWatch
          });
        } catch (error) {
          dispatch({
            command: 'setError',
            payload: error.body
          });
        }
      } else if (type) {
        const watchTypes = _watch.Watch.getWatchTypes();
        if ((0, _lodash.has)(watchTypes, type) && (0, _lodash.isFunction)(watchTypes[type])) {
          const WatchType = watchTypes[type];
          dispatch({
            command: 'setWatch',
            payload: new WatchType()
          });
        } else {
          dispatch({
            command: 'setError',
            payload: {
              message: 'Invalid watch type'
            }
          });
        }
      }
    };
    getWatch();
  }, [id, type]);
  (0, _react.useEffect)(() => {
    setBreadcrumbs([_breadcrumbs.listBreadcrumb, id ? _breadcrumbs.editBreadcrumb : _breadcrumbs.createBreadcrumb]);
  }, [id, setBreadcrumbs]);
  const errorCode = (0, _components.getPageErrorCode)(loadError);
  if (errorCode) {
    return /*#__PURE__*/_react.default.createElement(_components.PageError, {
      errorCode: errorCode,
      id: id
    });
  } else if (loadError) {
    return /*#__PURE__*/_react.default.createElement(_shared_imports.PageError, {
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.watcher.sections.watchEdit.errorTitle",
        defaultMessage: "Error loading watch"
      }),
      error: loadError
    });
  }
  if (!watch) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate.EmptyPrompt, null, /*#__PURE__*/_react.default.createElement(_components.SectionLoading, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.watcher.sections.watchEdit.loadingWatchDescription",
      defaultMessage: "Loading watch\u2026"
    })));
  }
  const pageTitle = getTitle(watch);
  let EditComponent = null;
  switch (watch.type) {
    case _constants.WATCH_TYPES.THRESHOLD:
      EditComponent = _components2.ThresholdWatchEdit;
      break;
    case _constants.WATCH_TYPES.MONITORING:
      EditComponent = _components2.MonitoringWatchEdit;
      break;
    case _constants.WATCH_TYPES.JSON:
    default:
      EditComponent = _components2.JsonWatchEdit;
  }
  return /*#__PURE__*/_react.default.createElement(_watch_context.WatchContext.Provider, {
    value: {
      watch,
      setWatchProperty,
      addAction
    }
  }, /*#__PURE__*/_react.default.createElement(EditComponent, {
    pageTitle: pageTitle
  }));
};
exports.WatchEditPage = WatchEditPage;