"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MonitoringWatch = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _base_watch = require("./base_watch");
var _constants = require("../../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * {@code MonitoringWatch} system defined watches created by the Monitoring plugin.
 */
class MonitoringWatch extends _base_watch.BaseWatch {
  constructor(props = {}) {
    props.type = _constants.WATCH_TYPES.MONITORING;
    super(props);
  }
  get upstreamJson() {
    const result = super.upstreamJson;
    Object.assign(result, {
      watch: this.watch
    });
    return result;
  }
  static fromUpstreamJson(upstreamWatch) {
    return new MonitoringWatch(upstreamWatch);
  }
}
exports.MonitoringWatch = MonitoringWatch;
(0, _defineProperty2.default)(MonitoringWatch, "isCreatable", false);