"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EmailAction = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _lodash = require("lodash");
var _base_action = require("./base_action");
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class EmailAction extends _base_action.BaseAction {
  constructor(props = {}) {
    super(props);
    const toArray = (0, _lodash.get)(props, 'to');
    this.to = (0, _lodash.isArray)(toArray) ? toArray : toArray && [toArray];
    const defaultSubject = _i18n.i18n.translate('xpack.watcher.models.emailAction.defaultSubjectText', {
      defaultMessage: 'Watch [{context}] has exceeded the threshold',
      values: {
        context: '{{ctx.metadata.name}}'
      }
    });
    this.subject = (0, _lodash.get)(props, 'subject', props.ignoreDefaults ? null : defaultSubject);
    this.body = (0, _lodash.get)(props, 'body');
  }
  validate() {
    const errors = {
      to: []
    };
    if (!this.to || !this.to.length) {
      errors.to.push(_i18n.i18n.translate('xpack.watcher.watchActions.email.emailRecipientIsRequiredValidationMessage', {
        defaultMessage: '"To" email address is required.'
      }));
    }
    return errors;
  }
  get upstreamJson() {
    const result = super.upstreamJson;
    Object.assign(result, {
      to: this.to,
      subject: this.subject,
      body: this.body,
      email: {
        to: this.to && this.to.length > 0 ? this.to : undefined,
        subject: this.subject,
        body: {
          text: this.body
        }
      }
    });
    return result;
  }
  get simulateMessage() {
    const toList = this.to.join(', ');
    return _i18n.i18n.translate('xpack.watcher.models.emailAction.simulateMessage', {
      defaultMessage: 'Sample email sent to {toList}',
      values: {
        toList
      }
    });
  }
  get simulateFailMessage() {
    const toList = this.to.join(', ');
    return _i18n.i18n.translate('xpack.watcher.models.emailAction.simulateFailMessage', {
      defaultMessage: 'Failed to send email to {toList}.',
      values: {
        toList
      }
    });
  }
  static fromUpstreamJson(upstreamAction) {
    return new EmailAction(upstreamAction);
  }
}
exports.EmailAction = EmailAction;
(0, _defineProperty2.default)(EmailAction, "typeName", _i18n.i18n.translate('xpack.watcher.models.emailAction.typeName', {
  defaultMessage: 'Email'
}));
(0, _defineProperty2.default)(EmailAction, "iconClass", 'email');
(0, _defineProperty2.default)(EmailAction, "selectMessage", _i18n.i18n.translate('xpack.watcher.models.emailAction.selectMessageText', {
  defaultMessage: 'Send an email from your server.'
}));
(0, _defineProperty2.default)(EmailAction, "simulatePrompt", _i18n.i18n.translate('xpack.watcher.models.emailAction.simulateButtonLabel', {
  defaultMessage: 'Send test email'
}));