"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConfirmWatchesModal = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ConfirmWatchesModal = ({
  modalOptions,
  callback
}) => {
  if (!modalOptions) {
    return null;
  }
  const {
    title,
    message,
    buttonType,
    buttonLabel
  } = modalOptions;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    buttonColor: buttonType ? buttonType : 'primary',
    title: title,
    onCancel: () => callback(),
    onConfirm: () => {
      callback(true);
    },
    cancelButtonText: _i18n.i18n.translate('xpack.watcher.sections.watchEdit.json.saveConfirmModal.cancelButtonLabel', {
      defaultMessage: 'Cancel'
    }),
    confirmButtonText: buttonLabel ? buttonLabel : _i18n.i18n.translate('xpack.watcher.sections.watchEdit.json.saveConfirmModal.saveButtonLabel', {
      defaultMessage: 'Save watch'
    })
  }, message);
};
exports.ConfirmWatchesModal = ConfirmWatchesModal;