"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _analytics = require("@kbn/analytics");
var _search_selection = require("./search_selection");
var _group_selection = require("./group_selection");
var _agg_based_selection = require("./agg_based_selection");
require("./dialog.scss");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

// TODO: redirect logic is specific to visualise & dashboard
// but it is likely should be decoupled. e.g. handled by the container instead
const basePath = `/create?`;
const baseUrl = `/app/visualize#${basePath}`;
class NewVisModal extends _react.default.Component {
  constructor(props) {
    super(props);
    (0, _defineProperty2.default)(this, "trackUiMetric", void 0);
    (0, _defineProperty2.default)(this, "setTab", tab => {
      this.setState({
        tab
      });
    });
    (0, _defineProperty2.default)(this, "onCloseModal", () => {
      this.setState({
        showSearchVisModal: false
      });
      this.props.onClose();
    });
    (0, _defineProperty2.default)(this, "onVisTypeSelected", visType => {
      if ('visConfig' in visType && visType.requiresSearch && visType.options.showIndexSelection) {
        this.setState({
          showSearchVisModal: true,
          visType
        });
      } else {
        this.redirectToVis(visType);
      }
    });
    (0, _defineProperty2.default)(this, "onSearchSelected", (searchId, searchType) => {
      this.redirectToVis(this.state.visType, searchType, searchId);
    });
    this.state = {
      showSearchVisModal: Boolean(this.props.selectedVisType),
      isMainDialogShown: !this.props.showAggsSelection,
      visType: this.props.selectedVisType,
      tab: 'recommended'
    };
  }
  render() {
    if (!this.props.isOpen) {
      return null;
    }
    const WizardComponent = this.state.isMainDialogShown ? _group_selection.GroupSelection : _agg_based_selection.AggBasedSelection;
    const selectionModal = this.state.showSearchVisModal && this.state.visType ? /*#__PURE__*/_react.default.createElement(_eui.EuiModal, {
      onClose: this.onCloseModal,
      className: "visNewVisSearchDialog",
      "aria-labelledby": "vis-wizard-modal-title"
    }, /*#__PURE__*/_react.default.createElement(_search_selection.SearchSelection, {
      contentClient: this.props.contentClient,
      uiSettings: this.props.uiSettings,
      onSearchSelected: this.onSearchSelected,
      visType: this.state.visType,
      goBack: () => this.setState({
        showSearchVisModal: false
      })
    })) : /*#__PURE__*/_react.default.createElement(_eui.EuiModal, {
      onClose: this.onCloseModal,
      className: this.state.isMainDialogShown ? 'visNewVisDialog' : 'visNewVisDialog--aggbased',
      "aria-labelledby": "vis-wizard-modal-title"
    }, /*#__PURE__*/_react.default.createElement(WizardComponent, {
      onVisTypeSelected: this.onVisTypeSelected,
      visTypesRegistry: this.props.visTypesRegistry,
      docLinks: this.props.docLinks,
      setTab: this.setTab,
      tab: this.state.tab,
      showMainDialog: shouldMainBeShown => {
        this.setState({
          isMainDialogShown: shouldMainBeShown
        });
        if (shouldMainBeShown) {
          this.setTab('legacy');
        }
      },
      openedAsRoot: this.props.showAggsSelection && !this.props.selectedVisType
    }));
    return selectionModal;
  }
  redirectToVis(visType, searchType, searchId) {
    if (this.trackUiMetric) {
      this.trackUiMetric(_analytics.METRIC_TYPE.CLICK, `${visType.name}:create`);
    }
    let params;
    if ('alias' in visType) {
      if (visType.alias && 'path' in visType.alias) {
        params = visType.alias.path;
        this.props.onClose();
        this.navigate(visType.alias.app, visType.alias.path);
      }
      return;
    }
    params = [`type=${encodeURIComponent(visType.name)}`];
    if (searchType) {
      params.push(`${searchType === 'search' ? 'savedSearchId' : 'indexPattern'}=${searchId}`);
    }
    params = params.concat(this.props.editorParams);
    this.props.onClose();
    if (this.props.outsideVisualizeApp) {
      this.navigate('visualize', `#${basePath}${params.join('&')}`);
    } else {
      location.assign(this.props.addBasePath(`${baseUrl}${params.join('&')}`));
    }
  }
  navigate(appId, params) {
    if (this.props.stateTransfer && this.props.originatingApp) {
      this.props.stateTransfer.navigateToEditor(appId, {
        path: params,
        state: {
          originatingApp: this.props.originatingApp
        }
      });
    } else {
      this.props.application.navigateToApp(appId, {
        path: params
      });
    }
  }
}

// Needed for React.lazy
// eslint-disable-next-line import/no-default-export
exports.default = NewVisModal;
(0, _defineProperty2.default)(NewVisModal, "defaultProps", {
  editorParams: []
});
module.exports = exports.default;