"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getScaleTypes = void 0;
var _i18n = require("@kbn/i18n");
var _types = require("../types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const getScaleTypes = () => [{
  text: _i18n.i18n.translate('visTypeXy.scaleTypes.linearText', {
    defaultMessage: 'Linear'
  }),
  value: _types.ScaleType.Linear
}, {
  text: _i18n.i18n.translate('visTypeXy.scaleTypes.logText', {
    defaultMessage: 'Log'
  }),
  value: _types.ScaleType.Log
}, {
  text: _i18n.i18n.translate('visTypeXy.scaleTypes.squareRootText', {
    defaultMessage: 'Square root'
  }),
  value: _types.ScaleType.SquareRoot
}];
exports.getScaleTypes = getScaleTypes;