"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ChartOptions = ChartOptions;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _public = require("@kbn/vis-default-editor-plugin/public");
var _line_options = require("./line_options");
var _point_options = require("./point_options");
var _common = require("../../../../../common");
var _collections = require("../../../collections");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const collections = (0, _collections.getConfigCollections)();
function ChartOptions({
  chart,
  index,
  valueAxes,
  changeValueAxis,
  setParamByIndex
}) {
  const setChart = (0, _react.useCallback)((paramName, value) => {
    setParamByIndex('seriesParams', index, paramName, value);
  }, [setParamByIndex, index]);
  const setValueAxis = (0, _react.useCallback)((paramName, value) => {
    changeValueAxis(index, paramName, value);
  }, [changeValueAxis, index]);
  const valueAxesOptions = (0, _react.useMemo)(() => [...valueAxes.map(({
    id,
    name
  }) => ({
    text: name,
    value: id
  })), {
    text: _i18n.i18n.translate('visTypeXy.controls.pointSeries.series.newAxisLabel', {
      defaultMessage: 'New axis…'
    }),
    value: 'new'
  }], [valueAxes]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_public.SelectOption, {
    id: `seriesValueAxis${index}`,
    label: _i18n.i18n.translate('visTypeXy.controls.pointSeries.series.valueAxisLabel', {
      defaultMessage: 'Value axis'
    }),
    options: valueAxesOptions,
    paramName: "valueAxis",
    value: chart.valueAxis,
    setValue: setValueAxis
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_public.SelectOption, {
    id: `seriesType${index}`,
    label: _i18n.i18n.translate('visTypeXy.controls.pointSeries.series.chartTypeLabel', {
      defaultMessage: 'Chart type'
    }),
    options: collections.chartTypes,
    paramName: "type",
    value: chart.type,
    setValue: setChart
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_public.SelectOption, {
    id: `seriesMode${index}`,
    label: _i18n.i18n.translate('visTypeXy.controls.pointSeries.series.modeLabel', {
      defaultMessage: 'Mode'
    }),
    options: collections.chartModes,
    paramName: "mode",
    value: chart.mode,
    setValue: setChart
  }))), chart.type === _common.ChartType.Area && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_public.SelectOption, {
    label: _i18n.i18n.translate('visTypeXy.controls.pointSeries.series.lineModeLabel', {
      defaultMessage: 'Line mode'
    }),
    options: collections.interpolationModes,
    paramName: "interpolate",
    value: chart.interpolate,
    setValue: setChart
  })), chart.type === _common.ChartType.Line && /*#__PURE__*/_react.default.createElement(_line_options.LineOptions, {
    chart: chart,
    setChart: setChart
  }), (chart.type === _common.ChartType.Area || chart.type === _common.ChartType.Line) && /*#__PURE__*/_react.default.createElement(_point_options.PointOptions, {
    chart: chart,
    setChart: setChart
  }));
}