"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.orderedDateAxis = orderedDateAxis;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function orderedDateAxis(chart) {
  const x = chart.aspects.x[0];
  const bounds = 'bounds' in x.params ? x.params.bounds : undefined;
  chart.ordered.date = true;
  if (bounds) {
    chart.ordered.min = typeof bounds.min === 'string' ? Date.parse(bounds.min) : bounds.min;
    chart.ordered.max = typeof bounds.max === 'string' ? Date.parse(bounds.max) : bounds.max;
  } else {
    chart.ordered.endzones = false;
  }
}