"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getVislibVisRenderer = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _reactDom = require("react-dom");
var _reactKibanaContextRender = require("@kbn/react-kibana-context-render");
var _public = require("@kbn/visualizations-plugin/public");
var _vis_type_vislib_vis_fn = require("./vis_type_vislib_vis_fn");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const VislibWrapper = /*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./vis_wrapper'))));
function shouldShowNoResultsMessage(visData, visType) {
  if (['goal', 'gauge'].includes(visType)) {
    return false;
  }
  const rows = visData === null || visData === void 0 ? void 0 : visData.rows;
  const isZeroHits = (visData === null || visData === void 0 ? void 0 : visData.hits) === 0 || rows && !rows.length;
  return Boolean(isZeroHits);
}
const getVislibVisRenderer = (core, charts) => ({
  name: _vis_type_vislib_vis_fn.vislibVisName,
  displayName: 'Vislib visualization',
  reuseDomNode: true,
  render: async (domNode, config, handlers) => {
    const [startServices] = await core.getStartServices();
    const showNoResult = shouldShowNoResultsMessage(config.visData, config.visType);
    handlers.onDestroy(() => (0, _reactDom.unmountComponentAtNode)(domNode));
    (0, _reactDom.render)(/*#__PURE__*/_react.default.createElement(_reactKibanaContextRender.KibanaRenderContextProvider, startServices, /*#__PURE__*/_react.default.createElement(_public.VisualizationContainer, {
      handlers: handlers,
      showNoResult: showNoResult
    }, /*#__PURE__*/_react.default.createElement(VislibWrapper, (0, _extends2.default)({}, config, {
      core: core,
      charts: charts,
      handlers: handlers
    })))), domNode);
  }
});
exports.getVislibVisRenderer = getVislibVisRenderer;