"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VegaHelpMenu = VegaHelpMenu;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _services = require("../services");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function VegaHelpMenu() {
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const onButtonClick = (0, _react.useCallback)(() => setIsPopoverOpen(!isPopoverOpen), [isPopoverOpen]);
  const closePopover = (0, _react.useCallback)(() => setIsPopoverOpen(false), []);
  const button = /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    iconType: "question",
    onClick: onButtonClick,
    "aria-label": _i18n.i18n.translate('visTypeVega.editor.vegaHelpButtonAriaLabel', {
      defaultMessage: 'Vega help'
    })
  });
  const items = [/*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    key: "vegaHelp",
    href: (0, _services.getDocLinks)().links.visualize.vega,
    target: "_blank",
    onClick: closePopover
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "visTypeVega.editor.vegaHelpLinkText",
    defaultMessage: "Kibana Vega help"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    key: "vegaLiteDocs",
    href: "https://vega.github.io/vega-lite/docs/",
    target: "_blank",
    onClick: closePopover
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "visTypeVega.editor.vegaLiteDocumentationLinkText",
    defaultMessage: "Vega-Lite documentation"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    key: "vegaDoc",
    href: "https://vega.github.io/vega/docs/",
    target: "_blank",
    onClick: closePopover
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "visTypeVega.editor.vegaDocumentationLinkText",
    defaultMessage: "Vega documentation"
  }))];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    id: "helpMenu",
    button: button,
    isOpen: isPopoverOpen,
    closePopover: closePopover,
    panelPaddingSize: "none",
    anchorPosition: "downLeft"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
    items: items
  }));
}