"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getTimeseriesVisRenderer = void 0;
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _reactDom = require("react-dom");
var _analytics = require("@kbn/analytics");
var _public = require("@kbn/visualizations-plugin/public");
var _reactKibanaContextRender = require("@kbn/react-kibana-context-render");
var _services = require("./services");
var _enums = require("../common/enums");
var _vis_data_utils = require("../common/vis_data_utils");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const TimeseriesVisualization = /*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./application/components/timeseries_visualization'))));
const checkIfDataExists = (visData, model) => {
  if ('type' in visData) {
    var _visData$model$id;
    const data = (0, _vis_data_utils.isVisTableData)(visData) ? visData.series : visData === null || visData === void 0 ? void 0 : (_visData$model$id = visData[model.id]) === null || _visData$model$id === void 0 ? void 0 : _visData$model$id.series;
    return Boolean(data === null || data === void 0 ? void 0 : data.length);
  }
  return false;
};

/** @internal **/
const extractContainerType = context => {
  if (context) {
    var _recursiveGet;
    const recursiveGet = item => {
      if (item.type) {
        return item;
      } else if (item.child) {
        return recursiveGet(item.child);
      }
    };
    return (_recursiveGet = recursiveGet(context)) === null || _recursiveGet === void 0 ? void 0 : _recursiveGet.type;
  }
};
const getTimeseriesVisRenderer = ({
  uiSettings,
  core
}) => ({
  name: 'timeseries_vis',
  reuseDomNode: true,
  render: async (domNode, config, handlers) => {
    const [startServices] = await core.getStartServices();
    handlers.onDestroy(() => {
      (0, _reactDom.unmountComponentAtNode)(domNode);
    });
    const {
      visParams: model,
      visData,
      syncColors,
      syncTooltips,
      syncCursor,
      canNavigateToLens
    } = config;
    const showNoResult = !checkIfDataExists(visData, model);
    const renderComplete = () => {
      const usageCollection = (0, _services.getUsageCollectionStart)();
      const containerType = extractContainerType(handlers.getExecutionContext());
      const visualizationType = 'tsvb';
      if (usageCollection && containerType) {
        const counterEvents = [`render_${visualizationType}_${model.type}`, model.use_kibana_indexes === false ? `render_${visualizationType}_index_pattern_string` : undefined, model.time_range_mode === _enums.TIME_RANGE_DATA_MODES.LAST_VALUE ? `render_${visualizationType}_last_value` : undefined, canNavigateToLens ? `render_${visualizationType}_convertable` : undefined].filter(Boolean);
        usageCollection.reportUiCounter(containerType, _analytics.METRIC_TYPE.COUNT, counterEvents);
      }
      handlers.done();
    };
    (0, _reactDom.render)(/*#__PURE__*/_react.default.createElement(_reactKibanaContextRender.KibanaRenderContextProvider, startServices, /*#__PURE__*/_react.default.createElement(_public.VisualizationContainer, {
      "data-test-subj": "timeseriesVis",
      handlers: handlers,
      renderComplete: renderComplete,
      showNoResult: showNoResult,
      error: (0, _lodash.get)(visData, [model.id, 'error'])
    }, /*#__PURE__*/_react.default.createElement(TimeseriesVisualization
    // it is mandatory to bind uiSettings because of "this" usage inside "get" method
    , {
      getConfig: uiSettings.get.bind(uiSettings),
      handlers: handlers,
      model: model,
      visData: visData,
      syncColors: syncColors,
      syncTooltips: syncTooltips,
      syncCursor: syncCursor,
      uiState: handlers.uiState,
      initialRender: renderComplete
    }))), domNode);
  }
});
exports.getTimeseriesVisRenderer = getTimeseriesVisRenderer;