"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UI_RESTRICTIONS = exports.SERIES = exports.PANEL = exports.METRIC = exports.INDEX_PATTERN = exports.FIELDS = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const UI_RESTRICTIONS = exports.UI_RESTRICTIONS = {
  '*': true
};
const INDEX_PATTERN = exports.INDEX_PATTERN = 'some-pattern';
const FIELDS = exports.FIELDS = {
  [INDEX_PATTERN]: [{
    type: 'date',
    name: '@timestamp'
  }, {
    type: 'number',
    name: 'system.cpu.user.pct'
  }, {
    type: 'histogram',
    name: 'histogram_value'
  }]
};
const METRIC = exports.METRIC = {
  id: 'sample_metric',
  type: 'avg',
  field: 'system.cpu.user.pct'
};
const SERIES = exports.SERIES = {
  metrics: [METRIC]
};
const PANEL = exports.PANEL = {
  type: 'timeseries',
  index_pattern: INDEX_PATTERN,
  series: [SERIES]
};