"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isSplitWithDateHistogram = exports.getBucketsColumns = void 0;
var _fields_utils = require("../../../../common/fields_utils");
var _convert = require("../convert");
var _columns = require("./columns");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const isSplitWithDateHistogram = (series, splitFields, dataView) => {
  if (series.terms_field && series.split_mode === 'terms' && splitFields.length) {
    for (const f of splitFields) {
      var _dataView$getFieldByN;
      const fieldType = (_dataView$getFieldByN = dataView.getFieldByName(f)) === null || _dataView$getFieldByN === void 0 ? void 0 : _dataView$getFieldByN.type;
      if (fieldType === 'date') {
        if (splitFields.length === 1) {
          return true;
        } else {
          // not supported terms with several field if one of them has date type
          return null;
        }
      }
    }
  }
  return false;
};
exports.isSplitWithDateHistogram = isSplitWithDateHistogram;
const isFiltersSeries = series => {
  return series.split_mode === 'filters' || series.split_mode === 'filter';
};
const isTermsSeries = series => {
  return series.split_mode === 'terms';
};
const isDateHistogramSeries = (series, isDateHistogram) => {
  return isDateHistogram && series.split_mode === 'terms';
};
const getBucketsColumns = (model, series, columns, dataView, isSplit = false, label, includeEmptyRowsForDateHistogram = true) => {
  if (isFiltersSeries(series)) {
    const filterColumn = (0, _convert.convertToFiltersColumn)(series, true);
    return (0, _columns.getValidColumns)([filterColumn]);
  }
  if (isTermsSeries(series)) {
    const splitFields = (0, _fields_utils.getFieldsForTerms)(series.terms_field);
    const isDateHistogram = isSplitWithDateHistogram(series, splitFields, dataView);
    if (isDateHistogram === null) {
      return null;
    }
    if (isDateHistogramSeries(series, isDateHistogram)) {
      const dateHistogramColumn = (0, _convert.convertToDateHistogramColumn)(model, series, dataView, {
        fieldName: splitFields[0],
        isSplit: true,
        includeEmptyRows: includeEmptyRowsForDateHistogram
      });
      return (0, _columns.getValidColumns)(dateHistogramColumn);
    }
    if (!splitFields.length) {
      return null;
    }
    const termsColumn = (0, _convert.convertToTermsColumn)(splitFields, series, columns, dataView, isSplit, label);
    return (0, _columns.getValidColumns)(termsColumn);
  }
  return [];
};
exports.getBucketsColumns = getBucketsColumns;