"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.convertToLastValueParams = exports.convertToLastValueColumn = void 0;
var _column = require("./column");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const convertToLastValueParams = metric => ({
  sortField: metric.order_by,
  showArrayValues: false
});
exports.convertToLastValueParams = convertToLastValueParams;
const convertToLastValueColumn = ({
  series,
  metrics,
  dataView
}, reducedTimeRange) => {
  var _currentMetric$field, _field$name;
  const currentMetric = metrics[metrics.length - 1];
  // We can only support top_hit with size 1
  if (currentMetric !== null && currentMetric !== void 0 && currentMetric.size && Number(currentMetric === null || currentMetric === void 0 ? void 0 : currentMetric.size) !== 1 || (currentMetric === null || currentMetric === void 0 ? void 0 : currentMetric.order) === 'asc') {
    return null;
  }
  const field = dataView.getFieldByName((_currentMetric$field = currentMetric.field) !== null && _currentMetric$field !== void 0 ? _currentMetric$field : 'document');
  if (!field) {
    return null;
  }
  return {
    operationType: 'last_value',
    sourceField: (_field$name = field.name) !== null && _field$name !== void 0 ? _field$name : 'document',
    ...(0, _column.createColumn)(series, currentMetric, undefined, {
      reducedTimeRange,
      timeShift: series.offset_time
    }),
    params: {
      ...convertToLastValueParams(currentMetric),
      ...(0, _column.getFormat)(series)
    }
  };
};
exports.convertToLastValueColumn = convertToLastValueColumn;