"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TimeSeries = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _i18n = require("@kbn/i18n");
var _charts = require("@elastic/charts");
var _public = require("@kbn/charts-plugin/public");
var _eui = require("@elastic/eui");
var _visualizationUtils = require("@kbn/visualization-utils");
var _services = require("../../../../services");
var _constants = require("../../constants");
var _area_decorator = require("./decorators/area_decorator");
var _bar_decorator = require("./decorators/bar_decorator");
var _stack_format = require("./utils/stack_format");
var _theme = require("./utils/theme");
var _enums = require("../../../../../common/enums");
var _empty_label = require("../../../../../common/empty_label");
var _get_split_by_terms_color = require("../../../lib/get_split_by_terms_color");
var _get_axis_label_string = require("../../../components/lib/get_axis_label_string");
var _series_domain_calculation = require("./utils/series_domain_calculation");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const generateAnnotationData = (values, formatter) => values.map(({
  key,
  docs
}) => ({
  dataValue: key,
  details: docs[0],
  header: formatter({
    value: key
  })
}));
const decorateFormatter = formatter => ({
  value
}) => formatter(value);

/** When displaying the annotation, we must slightly shift the labels for
 * the x-axis so that they do not overlap the annotations. **/
const TICK_LABEL_WITH_ANNOTATIONS_PADDING = 19;
const TimeSeries = ({
  backgroundColor,
  showGrid,
  legend,
  legendPosition,
  truncateLegend,
  maxLegendLines,
  tooltipMode,
  series,
  yAxis,
  onBrush,
  onFilterClick,
  xAxisFormatter,
  annotations,
  syncColors,
  syncTooltips,
  syncCursor,
  palettesService,
  interval,
  isLastBucketDropped,
  initialRender
}) => {
  var _document$getElementB, _window$_echDebugStat;
  // If the color isn't configured by the user, use the color mapping service
  // to assign a color from the Kibana palette. Colors will be shared across the
  // session, including dashboards.
  const {
    theme: themeService,
    activeCursor: activeCursorService
  } = (0, _services.getCharts)();
  const chartRef = (0, _react.useRef)();
  const chartBaseTheme = (0, _theme.getBaseTheme)(themeService.useChartsBaseTheme(), backgroundColor);
  const handleCursorUpdate = (0, _public.useActiveCursor)(activeCursorService, chartRef, {
    isDateHistogram: true
  });
  const hasVisibleAnnotations = (0, _react.useMemo)(() => (annotations !== null && annotations !== void 0 ? annotations : []).some(annotation => {
    var _annotation$data;
    return Boolean((_annotation$data = annotation.data) === null || _annotation$data === void 0 ? void 0 : _annotation$data.length);
  }), [annotations]);
  const onRenderChange = (0, _react.useCallback)(isRendered => {
    if (isRendered) {
      initialRender === null || initialRender === void 0 ? void 0 : initialRender();
    }
  }, [initialRender]);
  let tooltipFormatter = decorateFormatter(xAxisFormatter);
  if (!isLastBucketDropped) {
    const domainBounds = (0, _series_domain_calculation.calculateDomainForSeries)(series);
    tooltipFormatter = (0, _public.renderEndzoneTooltip)(interval, domainBounds === null || domainBounds === void 0 ? void 0 : domainBounds.domainStart, domainBounds === null || domainBounds === void 0 ? void 0 : domainBounds.domainEnd, xAxisFormatter);
  }
  const uiSettings = (0, _services.getUISettings)();
  const timeZone = (0, _visualizationUtils.getTimeZone)(uiSettings);
  const hasBarChart = series.some(({
    bars
  }) => bars === null || bars === void 0 ? void 0 : bars.show);

  // apply legend style change if bgColor is configured
  const classes = (0, _classnames.default)((0, _theme.getChartClasses)(backgroundColor));
  const onBrushEndListener = ({
    x
  }) => {
    if (!x) {
      return;
    }
    const [min, max] = x;
    onBrush(min, max, series);
  };
  const handleElementClick = points => {
    onFilterClick(series, points);
  };
  const getSeriesColor = (0, _react.useCallback)((seriesName, seriesGroupId, seriesId) => {
    const seriesById = series.filter(s => s.seriesId === seriesGroupId);
    const props = {
      seriesById,
      seriesName,
      seriesId,
      baseColor: seriesById[0].baseColor,
      seriesPalette: seriesById[0].palette,
      palettesRegistry: palettesService,
      syncColors
    };
    return (0, _get_split_by_terms_color.getSplitByTermsColor)(props) || null;
  }, [palettesService, series, syncColors]);
  const gridLineStyle = {
    ..._constants.GRID_LINE_CONFIG,
    visible: showGrid
  };
  return /*#__PURE__*/_react.default.createElement(_charts.Chart, {
    ref: chartRef,
    renderer: "canvas",
    className: classes
  }, /*#__PURE__*/_react.default.createElement(_charts.Tooltip, {
    snap: true,
    type: tooltipMode === _enums.TOOLTIP_MODES.SHOW_FOCUSED ? _charts.TooltipType.Follow : _charts.TooltipType.VerticalCursor,
    boundary: (_document$getElementB = document.getElementById('app-fixed-viewport')) !== null && _document$getElementB !== void 0 ? _document$getElementB : undefined,
    headerFormatter: tooltipFormatter
  }), /*#__PURE__*/_react.default.createElement(_charts.Settings, {
    debugState: (_window$_echDebugStat = window._echDebugStateFlag) !== null && _window$_echDebugStat !== void 0 ? _window$_echDebugStat : false,
    showLegend: legend,
    legendValues: [_charts.LegendValue.CurrentAndLastValue],
    onRenderChange: onRenderChange,
    allowBrushingLastHistogramBin: true,
    legendPosition: legendPosition,
    onBrushEnd: onBrushEndListener,
    onElementClick: args => handleElementClick(args),
    animateData: false,
    onPointerUpdate: syncCursor ? handleCursorUpdate : undefined,
    pointerUpdateDebounce: 0,
    theme: [{
      axes: {
        tickLabel: {
          padding: {
            inner: hasVisibleAnnotations ? TICK_LABEL_WITH_ANNOTATIONS_PADDING : chartBaseTheme.axes.tickLabel.padding.inner
          }
        }
      }
    }, hasBarChart ? {} : {
      crosshair: {
        band: {
          fill: '#F00'
        }
      }
    }, {
      background: {
        color: backgroundColor
      },
      legend: {
        labelOptions: {
          maxLines: truncateLegend ? maxLegendLines !== null && maxLegendLines !== void 0 ? maxLegendLines : 1 : 0
        }
      }
    }],
    baseTheme: chartBaseTheme,
    externalPointerEvents: {
      tooltip: {
        visible: syncTooltips,
        placement: _charts.Placement.Right
      }
    },
    locale: _i18n.i18n.getLocale()
  }), annotations.map(({
    id,
    data,
    icon,
    color
  }) => {
    const dataValues = generateAnnotationData(data, tooltipFormatter);
    const style = {
      line: {
        stroke: color
      }
    };
    return /*#__PURE__*/_react.default.createElement(_charts.LineAnnotation, {
      key: id,
      id: id,
      domainType: _charts.AnnotationDomainType.XDomain,
      dataValues: dataValues,
      marker: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        type: _constants.ICON_TYPES_MAP[icon] || 'asterisk'
      }),
      hideLinesTooltips: true,
      style: style
    });
  }), series.map(({
    id,
    seriesId,
    label,
    bars,
    lines,
    data,
    hideInLegend,
    truncateLegend,
    xScaleType,
    yScaleType,
    groupId,
    color,
    isSplitByTerms,
    stack,
    points,
    y1AccessorFormat,
    y0AccessorFormat,
    tickFormat
  }) => {
    const stackAccessors = (0, _stack_format.getStackAccessors)(stack);
    const isPercentage = stack === _constants.STACKED_OPTIONS.PERCENT;
    const isStacked = stack !== _constants.STACKED_OPTIONS.NONE;
    const key = `${id}-${label}`;
    const seriesName = label.toString();

    // The colors from the paletteService should be applied only when the timeseries is split by terms
    const splitColor = getSeriesColor(seriesName, seriesId, id);
    const finalColor = isSplitByTerms && splitColor ? splitColor : color;
    if (bars !== null && bars !== void 0 && bars.show) {
      return /*#__PURE__*/_react.default.createElement(_bar_decorator.BarSeriesDecorator, {
        key: key,
        seriesId: id,
        seriesGroupId: groupId,
        name: (0, _empty_label.getValueOrEmpty)(seriesName),
        data: data,
        hideInLegend: hideInLegend,
        truncateLegend: truncateLegend,
        bars: bars,
        color: finalColor,
        stackAccessors: stackAccessors,
        stackMode: isPercentage ? _charts.StackMode.Percentage : undefined,
        xScaleType: xScaleType,
        yScaleType: yScaleType,
        timeZone: timeZone,
        enableHistogramMode: isStacked,
        y1AccessorFormat: y1AccessorFormat,
        y0AccessorFormat: y0AccessorFormat,
        tickFormat: tickFormat
      });
    }
    if (lines !== null && lines !== void 0 && lines.show) {
      return /*#__PURE__*/_react.default.createElement(_area_decorator.AreaSeriesDecorator, {
        key: key,
        seriesId: id,
        seriesGroupId: groupId,
        name: (0, _empty_label.getValueOrEmpty)(seriesName),
        data: data,
        hideInLegend: hideInLegend,
        truncateLegend: truncateLegend,
        lines: lines,
        color: finalColor,
        stackAccessors: stackAccessors,
        stackMode: isPercentage ? _charts.StackMode.Percentage : undefined,
        points: points,
        xScaleType: xScaleType,
        yScaleType: yScaleType,
        timeZone: timeZone,
        enableHistogramMode: isStacked,
        y1AccessorFormat: y1AccessorFormat,
        y0AccessorFormat: y0AccessorFormat,
        tickFormat: tickFormat
      });
    }
    return null;
  }), yAxis.map(({
    id,
    groupId,
    position,
    tickFormatter,
    domain,
    hide
  }) => /*#__PURE__*/_react.default.createElement(_charts.Axis, {
    key: groupId,
    groupId: groupId,
    id: id,
    position: position,
    domain: domain,
    hide: hide,
    gridLine: gridLineStyle,
    ticks: 5,
    tickFormat: tickFormatter
  })), /*#__PURE__*/_react.default.createElement(_charts.Axis, {
    id: "bottom",
    position: _charts.Position.Bottom,
    title: (0, _get_axis_label_string.getAxisLabelString)(interval),
    tickFormat: xAxisFormatter,
    gridLine: gridLineStyle
  }));
};
exports.TimeSeries = TimeSeries;
TimeSeries.defaultProps = {
  showGrid: true,
  legend: true,
  legendPosition: 'right'
};
TimeSeries.propTypes = {
  backgroundColor: _propTypes.default.string,
  showGrid: _propTypes.default.bool,
  legend: _propTypes.default.bool,
  legendPosition: _propTypes.default.string,
  truncateLegend: _propTypes.default.bool,
  maxLegendLines: _propTypes.default.number,
  series: _propTypes.default.array,
  yAxis: _propTypes.default.array,
  onBrush: _propTypes.default.func,
  xAxisFormatter: _propTypes.default.func,
  annotations: _propTypes.default.array,
  interval: _propTypes.default.number,
  isLastBucketDropped: _propTypes.default.bool
};