"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = MarkdownVisualization;
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react = _interopRequireDefault(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _lodash = require("lodash");
var _react2 = require("@emotion/react");
var _public = require("@kbn/kibana-react-plugin/public");
var _error = require("../../error");
var _replace_vars = require("../../lib/replace_vars");
var _convert_series_to_vars = require("../../lib/convert_series_to_vars");
var _set_is_reversed = require("../../../lib/set_is_reversed");
var _vis_types = require("../_vis_types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const markdownStyles = (0, _react2.css)`
  display: flex;
  flex-direction: column;
  flex: 1 0 auto;
  position: relative;
`;
const markdownContentStyles = (0, _react2.css)`
  display: flex;
  flex-direction: column;
  flex: 1 0 auto;
  position: absolute;
  top: 0;
  left: 0;
  right: 0;
  bottom: 0;
  overflow: hidden;

  &.tvbMarkdown__content--middle {
    justify-content: center;
  }

  &.tvbMarkdown__content--bottom {
    justify-content: flex-end;
  }

  &.tvbMarkdown__content-isScrolling {
    overflow: auto;
  }
`;
function MarkdownVisualization(props) {
  const {
    backgroundColor,
    model,
    visData,
    getConfig,
    fieldFormatMap,
    initialRender,
    indexPattern
  } = props;
  const series = (0, _lodash.get)(visData, `${model.id}.series`, []);
  const variables = (0, _convert_series_to_vars.convertSeriesToVars)(series, model, getConfig, fieldFormatMap, indexPattern);
  const panelBackgroundColor = model.background_color || backgroundColor;
  const style = {
    backgroundColor: panelBackgroundColor
  };
  let markdown;
  if (model.markdown) {
    const markdownSource = (0, _replace_vars.replaceVars)(model.markdown, {}, {
      _all: variables,
      ...variables
    });
    const markdownClasses = (0, _classnames.default)('kbnMarkdown__body', {
      'kbnMarkdown__body--reversed': (0, _set_is_reversed.isBackgroundInverted)(panelBackgroundColor)
    });
    const contentClasses = (0, _classnames.default)('eui-scrollBar', 'tvbMarkdown__content', `tvbMarkdown__content--${model.markdown_vertical_align}`, {
      'tvbMarkdown__content-isScrolling': model.markdown_scrollbars
    }, markdownClasses);
    const markdownError = markdownSource instanceof Error ? markdownSource : null;
    markdown = /*#__PURE__*/_react.default.createElement("div", {
      className: "tvbMarkdown",
      css: markdownStyles,
      "data-test-subj": "tsvbMarkdown"
    }, markdownError && /*#__PURE__*/_react.default.createElement(_error.ErrorComponent, {
      error: markdownError
    }), /*#__PURE__*/_react.default.createElement(_react2.ClassNames, null, ({
      css,
      cx
    }) => /*#__PURE__*/_react.default.createElement("div", {
      className: cx(contentClasses,
      // wrapping select for markdown body to make sure selector specificity wins over base styles
      css([`.kbnMarkdown__body {
                      ${model.markdown_css}
                    }`], markdownContentStyles))
    }, /*#__PURE__*/_react.default.createElement("div", null, !markdownError && /*#__PURE__*/_react.default.createElement(_public.Markdown, {
      onRender: initialRender,
      markdown: markdownSource,
      openLinksInNewTab: model.markdown_openLinksInNewTab
    })))));
  }
  return /*#__PURE__*/_react.default.createElement("div", {
    className: "tvbVis",
    css: _vis_types.visStyles,
    style: style
  }, markdown);
}
MarkdownVisualization.propTypes = {
  backgroundColor: _propTypes.default.string,
  className: _propTypes.default.string,
  model: _propTypes.default.object,
  onBrush: _propTypes.default.func,
  onFilterClick: _propTypes.default.func,
  onChange: _propTypes.default.func,
  visData: _propTypes.default.object,
  getConfig: _propTypes.default.func
};

// default export required for React.Lazy
// eslint-disable-next-line import/no-default-export
module.exports = exports.default;