"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react = _interopRequireDefault(require("react"));
var _vis_with_splits = require("../../vis_with_splits");
var _get_metrics_field = require("../../lib/get_metrics_field");
var _tick_formatter = require("../../lib/tick_formatter");
var _create_field_formatter = require("../../lib/create_field_formatter");
var _lodash = require("lodash");
var _gauge = require("../../../visualizations/views/gauge");
var _last_value_utils = require("../../../../../common/last_value_utils");
var _enums = require("../../../../../common/enums");
var _operators_utils = require("../../../../../common/operators_utils");
var _vis_types = require("../_vis_types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function getColors(props) {
  const {
    model,
    visData
  } = props;
  const series = (0, _lodash.get)(visData, `${model.id}.series`, []).filter(s => !(0, _lodash.isUndefined)(s));
  let text;
  let gauge;
  if (model.gauge_color_rules) {
    model.gauge_color_rules.forEach(rule => {
      if (rule.operator) {
        var _series$;
        const value = (0, _last_value_utils.getLastValue)((_series$ = series[0]) === null || _series$ === void 0 ? void 0 : _series$.data);
        if ((0, _operators_utils.shouldOperate)(rule, value) && (0, _operators_utils.getOperator)(rule.operator)(value, rule.value)) {
          gauge = rule.gauge;
          text = rule.text;
        }
      }
    });
  }
  return {
    text,
    gauge
  };
}
function GaugeVisualization(props) {
  const {
    backgroundColor,
    model,
    visData,
    fieldFormatMap,
    getConfig
  } = props;
  const colors = getColors(props);
  const series = (0, _lodash.get)(visData, `${model.id}.series`, []).filter(row => row).map((row, i) => {
    const seriesDef = model.series.find(s => (0, _lodash.includes)(row.id, s.id));
    const newProps = {};
    if (seriesDef) {
      const hasTextColorRules = model.gauge_color_rules.some(({
        text
      }) => text);
      newProps.formatter = seriesDef.formatter === _enums.DATA_FORMATTERS.DEFAULT ? (0, _create_field_formatter.createFieldFormatter)((0, _get_metrics_field.getMetricsField)(seriesDef.metrics), fieldFormatMap, 'html', hasTextColorRules) : (0, _tick_formatter.createTickFormatter)(seriesDef.formatter, seriesDef.value_template, getConfig);
    }
    if (i === 0 && colors.gauge) newProps.color = colors.gauge;
    return (0, _lodash.assign)({}, row, newProps);
  });
  const panelBackgroundColor = model.background_color || backgroundColor;
  const style = {
    backgroundColor: panelBackgroundColor
  };
  const params = {
    metric: series[0],
    type: model.gauge_style || 'half',
    additionalLabel: props.additionalLabel,
    backgroundColor: panelBackgroundColor,
    initialRender: props.initialRender
  };
  if (colors.text) {
    params.valueColor = colors.text;
  }
  if (model.gauge_width) params.gaugeLine = model.gauge_width;
  if (model.gauge_inner_color) params.innerColor = model.gauge_inner_color;
  if (model.gauge_inner_width) params.innerLine = model.gauge_inner_width;
  if (model.gauge_max != null) params.max = model.gauge_max;
  return /*#__PURE__*/_react.default.createElement("div", {
    className: "tvbVis",
    css: _vis_types.visStyles,
    style: style
  }, /*#__PURE__*/_react.default.createElement(_gauge.Gauge, params));
}
GaugeVisualization.propTypes = {
  backgroundColor: _propTypes.default.string,
  className: _propTypes.default.string,
  additionalLabel: _propTypes.default.string,
  model: _propTypes.default.object,
  onBrush: _propTypes.default.func,
  onFilterClick: _propTypes.default.func,
  onChange: _propTypes.default.func,
  visData: _propTypes.default.object,
  getConfig: _propTypes.default.func
};
const gauge = exports.default = (0, _vis_with_splits.visWithSplits)(GaugeVisualization);

// default export required for React.Lazy
// eslint-disable-next-line import/no-default-export
module.exports = exports.default;