"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.reIdSeries = void 0;
var _uuid = require("uuid");
var _lodash = _interopRequireDefault(require("lodash"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const reIdSeries = source => {
  const series = _lodash.default.cloneDeep(source);
  series.id = (0, _uuid.v4)();
  series.metrics.forEach(metric => {
    const id = (0, _uuid.v4)();
    const metricId = metric.id;
    metric.id = id;
    if (series.terms_order_by === metricId) series.terms_order_by = id;
    series.metrics.filter(r => r.field === metricId).forEach(r => r.field = id);
    series.metrics.filter(r => r.type === 'calculation' && r.variables.some(v => v.field === metricId)).forEach(r => {
      r.variables.filter(v => v.field === metricId).forEach(v => {
        v.id = (0, _uuid.v4)();
        v.field = id;
      });
    });
  });
  return series;
};
exports.reIdSeries = reIdSeries;