"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSupportedFieldsByMetricType = getSupportedFieldsByMetricType;
var _public = require("@kbn/data-plugin/public");
var _common = require("@kbn/data-plugin/common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function getSupportedFieldsByMetricType(type) {
  switch (type) {
    case _common.METRIC_TYPES.CARDINALITY:
      return Object.values(_public.KBN_FIELD_TYPES).filter(t => t !== _public.KBN_FIELD_TYPES.HISTOGRAM);
    case _common.METRIC_TYPES.VALUE_COUNT:
      return Object.values(_public.KBN_FIELD_TYPES);
    case _common.METRIC_TYPES.AVG:
    case _common.METRIC_TYPES.SUM:
    case _common.METRIC_TYPES.MIN:
    case _common.METRIC_TYPES.MAX:
      return [_public.KBN_FIELD_TYPES.NUMBER, _public.KBN_FIELD_TYPES.HISTOGRAM];
    default:
      return [_public.KBN_FIELD_TYPES.NUMBER];
  }
}