"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getMetricsField = void 0;
var _lodash = require("lodash");
var _agg_utils = require("../../../../common/agg_utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const getMetricsField = metrics => {
  const selectedMetric = (0, _lodash.last)(metrics);
  if (selectedMetric) {
    var _getAggByPredicate;
    const {
      isFieldRequired,
      isFieldFormattingDisabled
    } = (_getAggByPredicate = (0, _agg_utils.getAggByPredicate)(selectedMetric.type)) === null || _getAggByPredicate === void 0 ? void 0 : _getAggByPredicate.meta;
    if (isFieldRequired && !isFieldFormattingDisabled) {
      var _metrics$find;
      return (0, _agg_utils.isBasicAgg)(selectedMetric) ? selectedMetric.field : (_metrics$find = metrics.find(({
        id
      }) => selectedMetric.field === id)) === null || _metrics$find === void 0 ? void 0 : _metrics$find.field;
    }
  }
};
exports.getMetricsField = getMetricsField;