"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getClickFilterData = void 0;
var _constants = require("../../visualizations/constants");
var _enums = require("../../../../common/enums");
var _constants2 = require("../../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const getClickFilterData = (points, tables, model) => {
  const data = [];
  points.forEach(point => {
    const [geometry] = point;
    const {
      specId
    } = point[1];
    // specId for a split series has the format
    // 61ca57f1-469d-11e7-af02-69e470af7417:Men's Accessories, <layer_id>:<split_label>
    const [layerId, splitLabel] = specId.split(_constants2.SERIES_SEPARATOR);
    const table = tables[layerId];
    const layer = model.series.filter(({
      id
    }) => id === layerId);
    let label = splitLabel;
    // compute label for filters split mode
    if (splitLabel && layer.length && layer[0].split_mode === _enums.BUCKET_TYPES.FILTERS) {
      var _layer$, _layer$$split_filters, _filter$0$filter;
      const filter = (_layer$ = layer[0]) === null || _layer$ === void 0 ? void 0 : (_layer$$split_filters = _layer$.split_filters) === null || _layer$$split_filters === void 0 ? void 0 : _layer$$split_filters.filter(({
        id
      }) => id === splitLabel);
      label = (filter === null || filter === void 0 ? void 0 : filter[0].label) || (filter === null || filter === void 0 ? void 0 : (_filter$0$filter = filter[0].filter) === null || _filter$0$filter === void 0 ? void 0 : _filter$0$filter.query);
    }
    const index = table.rows.findIndex(row => {
      const condition = geometry.x === row[_constants.X_ACCESSOR_INDEX] && geometry.y === row[_constants.X_ACCESSOR_INDEX + 1];
      if (splitLabel) {
        var _row$keys$join, _row$keys;
        const value = (_row$keys$join = (_row$keys = row[_constants.X_ACCESSOR_INDEX + 2].keys) === null || _row$keys === void 0 ? void 0 : _row$keys.join()) !== null && _row$keys$join !== void 0 ? _row$keys$join : row[_constants.X_ACCESSOR_INDEX + 2].toString();
        return condition && value === label;
      }
      return condition;
    });
    if (index < 0) return;

    // Filter out the metric column
    const bucketCols = table.columns.filter(col => {
      var _col$meta$sourceParam;
      return ((_col$meta$sourceParam = col.meta.sourceParams) === null || _col$meta$sourceParam === void 0 ? void 0 : _col$meta$sourceParam.schema) === 'group';
    });
    const newData = bucketCols.map(({
      id
    }) => {
      var _table$rows$index$id;
      return {
        table,
        column: parseInt(id, 10),
        row: index,
        value: (_table$rows$index$id = table.rows[index][id]) !== null && _table$rows$index$id !== void 0 ? _table$rows$index$id : null
      };
    });
    if (newData.length) {
      data.push(...newData);
    }
  });
  return data;
};
exports.getClickFilterData = getClickFilterData;