"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LastValueModePopover = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const LastValueModePopover = ({
  isIndicatorDisplayed,
  toggleIndicatorDisplay
}) => {
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const onButtonClick = (0, _react.useCallback)(() => setIsPopoverOpen(isOpen => !isOpen), []);
  const closePopover = (0, _react.useCallback)(() => setIsPopoverOpen(false), []);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    className: "tvbLastValueModePopover",
    css: (0, _react2.css)`
        height: auto;
      `,
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      iconType: 'gear',
      onClick: onButtonClick,
      "aria-label": _i18n.i18n.translate('visTypeTimeseries.lastValueModePopover.gearButton', {
        defaultMessage: 'Change last value indicator display option'
      })
    }),
    isOpen: isPopoverOpen,
    closePopover: closePopover
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "tvbLastValueModePopoverBody",
    css: (0, _react2.css)`
          width: 360px;
        `
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, null, _i18n.i18n.translate('visTypeTimeseries.lastValueModePopover.title', {
    defaultMessage: 'Last value options'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    checked: isIndicatorDisplayed,
    label: _i18n.i18n.translate('visTypeTimeseries.lastValueModePopover.switch', {
      defaultMessage: 'Show label when using Last value mode'
    }),
    onChange: toggleIndicatorDisplay
  })));
};
exports.LastValueModePopover = LastValueModePopover;