"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StandardAgg = StandardAgg;
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react = _interopRequireDefault(require("react"));
var _agg_select = require("./agg_select");
var _field_select = require("./field_select");
var _agg_row = require("./agg_row");
var _create_change_handler = require("../lib/create_change_handler");
var _create_select_handler = require("../lib/create_select_handler");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _get_supported_fields_by_metric_type = require("../lib/get_supported_fields_by_metric_type");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function StandardAgg(props) {
  const {
    model,
    panel,
    series,
    fields,
    uiRestrictions
  } = props;
  const handleChange = (0, _create_change_handler.createChangeHandler)(props.onChange, model);
  const handleSelectChange = (0, _create_select_handler.createSelectHandler)(handleChange);
  const restrictFields = (0, _get_supported_fields_by_metric_type.getSupportedFieldsByMetricType)(model.type);
  const indexPattern = series.override_index_pattern ? series.series_index_pattern : panel.index_pattern;
  const htmlId = (0, _eui.htmlIdGenerator)();
  return /*#__PURE__*/_react.default.createElement(_agg_row.AggRow, {
    disableDelete: props.disableDelete,
    model: props.model,
    onAdd: props.onAdd,
    onDelete: props.onDelete,
    siblings: props.siblings,
    dragHandleProps: props.dragHandleProps
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormLabel, {
    htmlFor: htmlId('aggregation')
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "visTypeTimeseries.stdAgg.aggregationLabel",
    defaultMessage: "Aggregation"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  }), /*#__PURE__*/_react.default.createElement(_agg_select.AggSelect, {
    id: htmlId('aggregation'),
    panelType: props.panel.type,
    siblings: props.siblings,
    value: model.type,
    onChange: handleSelectChange('type'),
    fullWidth: true
  })), model.type !== 'count' ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_field_select.FieldSelect, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "visTypeTimeseries.stdAgg.fieldLabel",
      defaultMessage: "Field"
    }),
    fields: fields,
    type: model.type,
    restrict: restrictFields,
    indexPattern: indexPattern,
    value: model.field,
    onChange: value => handleChange({
      field: value === null || value === void 0 ? void 0 : value[0]
    }),
    uiRestrictions: uiRestrictions,
    fullWidth: true
  })) : null));
}
StandardAgg.propTypes = {
  disableDelete: _propTypes.default.bool,
  fields: _propTypes.default.object,
  model: _propTypes.default.object,
  onAdd: _propTypes.default.func,
  onChange: _propTypes.default.func,
  onDelete: _propTypes.default.func,
  panel: _propTypes.default.object,
  series: _propTypes.default.object,
  siblings: _propTypes.default.array,
  uiRestrictions: _propTypes.default.object
};