"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AddDeleteButtons = AddDeleteButtons;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function AddDeleteButtons(props) {
  const {
    testSubj
  } = props;
  const createDelete = () => {
    if (props.disableDelete) {
      return null;
    }
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: props.deleteTooltip
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      "data-test-subj": `${testSubj}DeleteBtn`,
      "aria-label": props.deleteTooltip,
      color: "danger",
      iconType: "trash",
      onClick: props.onDelete
    })));
  };
  const createAdd = () => {
    if (props.disableAdd) {
      return null;
    }
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: props.addTooltip
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      "data-test-subj": `${testSubj}AddBtn`,
      "aria-label": props.addTooltip,
      iconType: "plusInCircle",
      onClick: props.onAdd
    })));
  };
  const createClone = () => {
    let cloneBtn = null;
    if (props.onClone && !props.disableAdd) {
      cloneBtn = /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
        content: props.cloneTooltip
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
        "data-test-subj": `${testSubj}CloneBtn`,
        "aria-label": props.cloneTooltip,
        iconType: "copy",
        onClick: props.onClone
      })));
    }
    return cloneBtn;
  };
  const createActivatePanel = () => {
    let activatePanelBtn = null;
    if ((0, _lodash.isBoolean)(props.isPanelActive)) {
      const tooltip = props.isPanelActive ? props.deactivatePanelTooltip : props.activatePanelTooltip;
      const iconType = props.isPanelActive ? 'eye' : 'eyeClosed';
      activatePanelBtn = /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
        content: tooltip
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
        "data-test-subj": `${testSubj}ActivatePanelBtn`,
        "aria-label": tooltip,
        iconType: iconType,
        onClick: props.togglePanelActivation
      })));
    }
    return activatePanelBtn;
  };
  const deleteBtn = createDelete();
  const addBtn = createAdd();
  const cloneBtn = createClone();
  const activatePanelBtn = createActivatePanel();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    responsive: props.responsive,
    justifyContent: "flexEnd"
  }, activatePanelBtn, cloneBtn, addBtn, deleteBtn);
}
AddDeleteButtons.defaultProps = {
  testSubj: 'Add',
  activeTooltip: _i18n.i18n.translate('visTypeTimeseries.addDeleteButtons.addButtonDefaultTooltip', {
    defaultMessage: 'Add'
  }),
  addTooltip: _i18n.i18n.translate('visTypeTimeseries.addDeleteButtons.addButtonDefaultTooltip', {
    defaultMessage: 'Add'
  }),
  deleteTooltip: _i18n.i18n.translate('visTypeTimeseries.addDeleteButtons.deleteButtonDefaultTooltip', {
    defaultMessage: 'Delete'
  }),
  cloneTooltip: _i18n.i18n.translate('visTypeTimeseries.addDeleteButtons.cloneButtonDefaultTooltip', {
    defaultMessage: 'Clone'
  }),
  activatePanelTooltip: _i18n.i18n.translate('visTypeTimeseries.addDeleteButtons.reEnableTooltip', {
    defaultMessage: 'Re-enable'
  }),
  deactivatePanelTooltip: _i18n.i18n.translate('visTypeTimeseries.addDeleteButtons.temporarilyDisableTooltip', {
    defaultMessage: 'Temporarily Disable'
  })
};