"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TableVisPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _services = require("./services");
var _register_vis = require("./register_vis");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/** @internal */

/** @internal */

/** @internal */
class TableVisPlugin {
  constructor(initializerContext) {
    (0, _defineProperty2.default)(this, "initializerContext", void 0);
    this.initializerContext = initializerContext;
  }
  setup(core, deps) {
    const {
      readOnly
    } = this.initializerContext.config.get();
    (0, _register_vis.registerTableVis)(core, deps, Boolean(readOnly));
  }
  start(core, {
    fieldFormats,
    dataViews
  }) {
    (0, _services.setFormatService)(fieldFormats);
    (0, _services.setDataViewsStart)(dataViews);
  }
}
exports.TableVisPlugin = TableVisPlugin;