"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSubAggParamsHandlers = useSubAggParamsHandlers;
var _react = require("react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function useSubAggParamsHandlers(agg, aggParam, subAgg, setValue) {
  const setAggParamValue = (0, _react.useCallback)((_, paramName, val) => {
    const parsedParams = subAgg.serialize();
    const params = {
      ...parsedParams,
      params: {
        ...parsedParams.params,
        [paramName]: val
      }
    };
    setValue(aggParam.makeAgg(agg, params));
  }, [agg, aggParam, setValue, subAgg]);
  const onAggTypeChange = (0, _react.useCallback)((_, aggType) => {
    const parsedAgg = subAgg.serialize();
    const parsedAggParams = parsedAgg.params;

    // we should share between aggs only field and base params: json, label, time shift.
    const params = {
      ...parsedAgg,
      params: {
        field: parsedAggParams.field,
        json: parsedAggParams.json,
        customLabel: parsedAggParams.customLabel,
        timeShift: parsedAggParams.timeShift
      },
      // @ts-ignore - Need to verify type
      type: aggType
    };
    setValue(aggParam.makeAgg(agg, params));
  }, [agg, aggParam, setValue, subAgg]);
  return {
    onAggTypeChange,
    setAggParamValue
  };
}