"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TopFieldParamEditor = TopFieldParamEditor;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _field = require("./field");
var _top_aggregate = require("./top_aggregate");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function TopFieldParamEditor(props) {
  const compatibleAggs = (0, _top_aggregate.getCompatibleAggs)(props.agg);
  let customError;
  if (props.value && !compatibleAggs.length) {
    customError = _i18n.i18n.translate('visDefaultEditor.controls.aggregateWith.noAggsErrorTooltip', {
      defaultMessage: 'The chosen field has no compatible aggregations.'
    });
  }
  return /*#__PURE__*/_react.default.createElement(_field.FieldParamEditor, (0, _extends2.default)({}, props, {
    customError: customError
  }));
}