"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DefaultEditorAggParam = DefaultEditorAggParam;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _agg_params_state = require("./agg_params_state");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function DefaultEditorAggParam(props) {
  const {
    agg,
    aggParam,
    paramEditor: ParamEditor,
    setAggParamValue,
    onChangeParamsState,
    ...rest
  } = props;
  const setValidity = (0, _react.useCallback)(valid => {
    onChangeParamsState({
      type: _agg_params_state.AGG_PARAMS_ACTION_KEYS.VALID,
      paramName: aggParam.name,
      payload: valid
    });
  }, [onChangeParamsState, aggParam.name]);

  // setTouched can be called from sub-agg which passes a parameter
  const setTouched = (0, _react.useCallback)((isTouched = true) => {
    onChangeParamsState({
      type: _agg_params_state.AGG_PARAMS_ACTION_KEYS.TOUCHED,
      paramName: aggParam.name,
      payload: isTouched
    });
  }, [onChangeParamsState, aggParam.name]);
  const setValue = (0, _react.useCallback)(value => {
    if (props.value !== value) {
      setAggParamValue(agg.id, aggParam.name, value);
    }
  }, [setAggParamValue, agg.id, aggParam.name, props.value]);
  (0, _react.useEffect)(() => {
    if (aggParam.shouldShow && !aggParam.shouldShow(agg)) {
      setValidity(true);
    }
  }, [agg, agg.params.field, aggParam, setValidity]);
  if (aggParam.shouldShow && !aggParam.shouldShow(agg)) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(ParamEditor, (0, _extends2.default)({
    agg: agg,
    aggParam: aggParam,
    setValidity: setValidity,
    setTouched: setTouched,
    setValue: setValue
  }, rest));
}