"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useMapFilters = void 0;
var _react = require("react");
var _apmDataView = require("@kbn/apm-data-view");
var _use_url_params = require("../../../../context/url_params_context/use_url_params");
var _elasticsearch_fieldnames = require("../../../../../common/elasticsearch_fieldnames");
var _use_ux_plugin_context = require("../../../../context/use_ux_plugin_context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getWildcardFilter = (field, value, spaceId) => {
  return {
    meta: {
      index: (0, _apmDataView.getStaticDataViewId)(spaceId),
      alias: null,
      negate: false,
      disabled: false,
      type: 'term',
      key: field,
      params: {
        query: value
      }
    },
    query: {
      wildcard: {
        [field]: {
          value: `*${value}*`
        }
      }
    }
  };
};
const getMatchFilter = (field, value, spaceId) => {
  return {
    meta: {
      index: (0, _apmDataView.getStaticDataViewId)(spaceId),
      alias: null,
      negate: false,
      disabled: false,
      type: 'phrase',
      key: field,
      params: {
        query: value
      }
    },
    query: {
      term: {
        [field]: value
      }
    }
  };
};
const getMultiMatchFilter = (field, values, spaceId, negate = false) => {
  return {
    meta: {
      index: (0, _apmDataView.getStaticDataViewId)(spaceId),
      type: 'phrases',
      key: field,
      value: values.join(', '),
      params: values,
      alias: null,
      negate,
      disabled: false
    },
    query: {
      bool: {
        should: values.map(value => ({
          match_phrase: {
            [field]: value
          }
        })),
        minimum_should_match: 1
      }
    }
  };
};
function getExistFilter(spaceId) {
  return {
    meta: {
      index: (0, _apmDataView.getStaticDataViewId)(spaceId),
      alias: null,
      negate: false,
      disabled: false,
      type: 'exists',
      key: 'transaction.marks.navigationTiming.fetchStart',
      value: 'exists'
    },
    query: {
      exists: {
        field: 'transaction.marks.navigationTiming.fetchStart'
      }
    }
  };
}
const useMapFilters = () => {
  const {
    urlParams,
    uxUiFilters
  } = (0, _use_url_params.useLegacyUrlParams)();
  const {
    spaceId
  } = (0, _use_ux_plugin_context.useUxPluginContext)();
  const {
    serviceName,
    searchTerm
  } = urlParams;
  const {
    browser,
    device,
    os,
    location,
    transactionUrl,
    browserExcluded,
    deviceExcluded,
    osExcluded,
    locationExcluded,
    transactionUrlExcluded
  } = uxUiFilters;
  return (0, _react.useMemo)(() => {
    const filters = [getExistFilter(spaceId)];
    if (serviceName) {
      filters.push(getMatchFilter(_elasticsearch_fieldnames.SERVICE_NAME, serviceName, spaceId));
    }
    if (browser) {
      filters.push(getMultiMatchFilter(_elasticsearch_fieldnames.USER_AGENT_NAME, browser, spaceId));
    }
    if (device) {
      filters.push(getMultiMatchFilter(_elasticsearch_fieldnames.USER_AGENT_DEVICE, device, spaceId));
    }
    if (os) {
      filters.push(getMultiMatchFilter(_elasticsearch_fieldnames.USER_AGENT_OS, os, spaceId));
    }
    if (location) {
      filters.push(getMultiMatchFilter(_elasticsearch_fieldnames.CLIENT_GEO_COUNTRY_ISO_CODE, location, spaceId));
    }
    if (transactionUrl) {
      filters.push(getMultiMatchFilter(_elasticsearch_fieldnames.TRANSACTION_URL, transactionUrl, spaceId));
    }
    if (browserExcluded) {
      filters.push(getMultiMatchFilter(_elasticsearch_fieldnames.USER_AGENT_NAME, browserExcluded, spaceId, true));
    }
    if (deviceExcluded) {
      filters.push(getMultiMatchFilter(_elasticsearch_fieldnames.USER_AGENT_DEVICE, deviceExcluded, spaceId, true));
    }
    if (osExcluded) {
      filters.push(getMultiMatchFilter(_elasticsearch_fieldnames.USER_AGENT_OS, osExcluded, spaceId, true));
    }
    if (locationExcluded) {
      filters.push(getMultiMatchFilter(_elasticsearch_fieldnames.CLIENT_GEO_COUNTRY_ISO_CODE, locationExcluded, spaceId, true));
    }
    if (transactionUrlExcluded) {
      filters.push(getMultiMatchFilter(_elasticsearch_fieldnames.TRANSACTION_URL, transactionUrlExcluded, spaceId, true));
    }
    if (searchTerm) {
      filters.push(getWildcardFilter(_elasticsearch_fieldnames.TRANSACTION_URL, searchTerm, spaceId));
    }
    return filters;
  }, [serviceName, browser, device, os, location, transactionUrl, browserExcluded, deviceExcluded, osExcluded, locationExcluded, transactionUrlExcluded, searchTerm, spaceId]);
};
exports.useMapFilters = useMapFilters;