"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.selectableRenderOptions = selectableRenderOptions;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _uiTheme = require("@kbn/ui-theme");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const StyledSpan = _styledComponents.default.span`
  color: ${_uiTheme.euiLightVars.euiColorSuccessText};
  font-weight: 500;
  :not(:last-of-type)::after {
    content: '•';
    margin: 0 4px;
  }
`;
const StyledListSpan = _styledComponents.default.span`
  display: block;
  margin-top: 4px;
  font-size: 12px;
`;
function selectableRenderOptions(option, searchValue) {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiHighlight, {
    className: "euiSelectableTemplateSitewide__listItemTitle",
    search: searchValue
  }, option.label), renderOptionMeta(option.meta));
}
function renderOptionMeta(meta) {
  if (!meta || meta.length < 1) return;
  return /*#__PURE__*/_react.default.createElement(StyledListSpan, null, meta.map(item => /*#__PURE__*/_react.default.createElement(StyledSpan, {
    key: item
  }, item)));
}