"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UserAvatar = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _user_profile = require("./user_profile");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * Convenience type for a {@link UserProfile} with avatar data
 */

/**
 * Props of {@link UserAvatar} component
 */

/**
 * Renders an avatar given a user profile
 */
const UserAvatar = ({
  user,
  avatar,
  ...rest
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  if (!user) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiAvatar, (0, _extends2.default)({
      name: "",
      color: euiTheme.colors.lightestShade,
      initials: "?"
    }, rest));
  }
  const displayLabel = (0, _user_profile.getUserDisplayLabel)(user);
  if (avatar !== null && avatar !== void 0 && avatar.imageUrl) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiAvatar, (0, _extends2.default)({
      name: displayLabel,
      imageUrl: avatar.imageUrl,
      color: "plain"
    }, rest));
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiAvatar, (0, _extends2.default)({
    name: displayLabel,
    initials: (0, _user_profile.getUserAvatarInitials)(user, avatar),
    initialsLength: _user_profile.USER_AVATAR_MAX_INITIALS,
    color: (0, _user_profile.getUserAvatarColor)(user, avatar)
  }, rest));
};
exports.UserAvatar = UserAvatar;