"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UserProfilesProvider = exports.UserProfilesKibanaProvider = void 0;
exports.useUserProfiles = useUserProfiles;
var _react = _interopRequireWildcard(require("react"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const UserProfilesContext = /*#__PURE__*/_react.default.createContext(null);

/**
 * Abstract external service Provider.
 */
const UserProfilesProvider = ({
  children,
  ...services
}) => {
  return /*#__PURE__*/_react.default.createElement(UserProfilesContext.Provider, {
    value: services
  }, children);
};

/**
 * Kibana-specific service types.
 */
exports.UserProfilesProvider = UserProfilesProvider;
/**
 * Kibana-specific Provider that maps to known dependency types.
 */
const UserProfilesKibanaProvider = ({
  children,
  ...services
}) => {
  const {
    core: {
      notifications,
      ...startServices
    },
    security: {
      userProfiles: userProfileApiClient
    },
    toMountPoint: toMountPointUtility
  } = services;
  return /*#__PURE__*/_react.default.createElement(UserProfilesProvider, {
    userProfileApiClient: userProfileApiClient,
    notifySuccess: ({
      title,
      text
    }, options) => {
      const toastOptions = {};
      if (options !== null && options !== void 0 && options.durationMs) {
        toastOptions.toastLifeTimeMs = options.durationMs;
      }
      notifications.toasts.addSuccess({
        title,
        text: text ? toMountPointUtility(text, startServices) : undefined
      }, toastOptions);
    }
  }, children);
};

/**
 * React hook for accessing pre-wired services.
 */
exports.UserProfilesKibanaProvider = UserProfilesKibanaProvider;
function useUserProfiles() {
  const context = (0, _react.useContext)(UserProfilesContext);
  if (!context) {
    throw new Error('UserProfilesContext is missing. Ensure your component or React root is wrapped with <UserProfilesProvider /> or <UserProfilesKibanaProvider />.');
  }
  return context;
}