"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.storeCounter = exports.serializeCounterKey = exports.registerUsageCountersSavedObjectTypes = exports.USAGE_COUNTERS_SAVED_OBJECT_TYPE = void 0;
var _moment = _interopRequireDefault(require("moment"));
var _coreSavedObjectsServer = require("@kbn/core-saved-objects-server");
var _coreSavedObjectsUtilsServer = require("@kbn/core-saved-objects-utils-server");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * The attributes stored in the UsageCounters' SavedObjects
 */

/**
 * The structure of the SavedObjects of type "usage-counters"
 */

/** The Saved Objects type for Usage Counters **/
const USAGE_COUNTERS_SAVED_OBJECT_TYPE = exports.USAGE_COUNTERS_SAVED_OBJECT_TYPE = 'usage-counter';
const registerUsageCountersSavedObjectTypes = savedObjectsSetup => {
  savedObjectsSetup.registerType({
    name: USAGE_COUNTERS_SAVED_OBJECT_TYPE,
    indexPattern: _coreSavedObjectsServer.USAGE_COUNTERS_SAVED_OBJECT_INDEX,
    hidden: false,
    namespaceType: 'single',
    mappings: {
      dynamic: false,
      properties: {
        domainId: {
          type: 'keyword'
        },
        counterName: {
          type: 'keyword'
        },
        counterType: {
          type: 'keyword'
        },
        source: {
          type: 'keyword'
        },
        count: {
          type: 'integer'
        }
      }
    }
  });

  // DEPRECATED: we keep it just to ensure non-reindex migrations (serverless)
  savedObjectsSetup.registerType({
    name: 'usage-counters',
    hidden: false,
    namespaceType: 'agnostic',
    mappings: {
      dynamic: false,
      properties: {
        domainId: {
          type: 'keyword'
        }
      }
    }
  });
};

/**
 * Parameters to the `serializeCounterKey` method
 * @internal used in kibana_usage_collectors
 */
exports.registerUsageCountersSavedObjectTypes = registerUsageCountersSavedObjectTypes;
/**
 * Generates a key based on the UsageCounter details
 * @internal used in kibana_usage_collectors
 * @param opts {@link SerializeCounterKeyParams}
 */
const serializeCounterKey = params => {
  const {
    domainId,
    counterName,
    counterType,
    namespace,
    source,
    date
  } = params;
  const dayDate = (0, _moment.default)(date).format('YYYYMMDD');
  if (namespace && namespace !== _coreSavedObjectsUtilsServer.DEFAULT_NAMESPACE_STRING) {
    // e.g. 'someNamespace:dashboards:viewed:total:ui:20240628'
    return `${namespace}:${domainId}:${counterName}:${counterType}:${source}:${dayDate}`;
  } else {
    // e.g. 'dashboards:viewed:total:ui:20240628'
    return `${domainId}:${counterName}:${counterType}:${source}:${dayDate}`;
  }
};
exports.serializeCounterKey = serializeCounterKey;
const storeCounter = async ({
  metric,
  soRepository
}) => {
  const {
    namespace,
    counterName,
    counterType,
    domainId,
    source,
    incrementBy
  } = metric;
  // same counter key can be used in different namespaces (no need to make namespace part of the key)
  const key = serializeCounterKey({
    domainId,
    counterName,
    counterType,
    source,
    date: _moment.default.now()
  });
  return await soRepository.incrementCounter(USAGE_COUNTERS_SAVED_OBJECT_TYPE, key, [{
    fieldName: 'count',
    incrementBy
  }], {
    ...(namespace && {
      namespace
    }),
    upsertAttributes: {
      domainId,
      counterName,
      counterType,
      source
    },
    refresh: false
  });
};
exports.storeCounter = storeCounter;