"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UptimePlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _rxjs = require("rxjs");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/core/public");
var _public2 = require("@kbn/observability-plugin/public");
var _coreApplicationBrowser = require("@kbn/core-application-browser");
var _plugin = require("../common/constants/plugin");
var _fleet_package = require("./legacy_uptime/components/fleet_package");
var _lazy_synthetics_custom_assets_extension = require("./legacy_uptime/components/fleet_package/lazy_synthetics_custom_assets_extension");
var _alert_types = require("./legacy_uptime/lib/alert_types");
var _kibana_services = require("./kibana_services");
var _overview = require("./locators/overview");
var _uptime_overview_fetcher = require("./legacy_uptime/app/uptime_overview_fetcher");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
class UptimePlugin {
  constructor(initContext) {
    (0, _defineProperty2.default)(this, "uptimeAppUpdater", new _rxjs.BehaviorSubject(() => ({})));
    (0, _defineProperty2.default)(this, "experimentalFeatures", {
      ruleFormV2Enabled: false
    });
    this.initContext = initContext;
    this.experimentalFeatures = this.initContext.config.get().experimental || this.experimentalFeatures;
  }
  setup(core, plugins) {
    if (plugins.home) {
      plugins.home.featureCatalogue.register({
        id: _plugin.PLUGIN.ID,
        title: _plugin.PLUGIN.TITLE,
        description: _plugin.PLUGIN.DESCRIPTION,
        icon: 'uptimeApp',
        path: '/app/uptime',
        showOnHomePage: false,
        category: 'data'
      });
    }
    const getUptimeDataHelper = async () => {
      const [coreStart] = await core.getStartServices();
      return (0, _uptime_overview_fetcher.UptimeDataHelper)(coreStart);
    };
    plugins.observability.dashboard.register({
      appName: 'uptime',
      hasData: async () => {
        const dataHelper = await getUptimeDataHelper();
        const status = await dataHelper.indexStatus();
        return {
          hasData: status.indexExists,
          indices: status.indices
        };
      },
      fetchData: async params => {
        const dataHelper = await getUptimeDataHelper();
        return await dataHelper.overviewData(params);
      }
    });
    plugins.exploratoryView.register({
      appName: 'uptime',
      hasData: async () => {
        const dataHelper = await getUptimeDataHelper();
        const status = await dataHelper.indexStatus();
        return {
          hasData: status.indexExists,
          indices: status.indices
        };
      },
      fetchData: async params => {
        const dataHelper = await getUptimeDataHelper();
        return await dataHelper.overviewData(params);
      }
    });
    const appKeywords = ['Synthetics', 'availability', 'browser', 'checks', 'digital', 'reachability', 'reachable', 'response duration', 'response time', 'monitors', 'outside in', 'performance', 'pings', 'web performance', 'web perf'];
    core.application.register({
      id: _plugin.PLUGIN.ID,
      euiIconType: 'logoObservability',
      order: 8400,
      title: _plugin.PLUGIN.TITLE,
      category: _public.DEFAULT_APP_CATEGORIES.observability,
      keywords: appKeywords,
      deepLinks: [{
        id: 'Down monitors',
        title: 'Down monitors',
        path: '/?statusFilter=down'
      }, {
        id: 'Certificates',
        title: 'TLS Certificates',
        path: '/certificates'
      }, {
        id: 'Settings',
        title: 'Settings',
        path: '/settings'
      }],
      mount: async params => {
        const [coreStart, corePlugins] = await core.getStartServices();
        const {
          renderApp
        } = await Promise.resolve().then(() => _interopRequireWildcard(require('./legacy_uptime/app/render_app')));
        return renderApp(coreStart, plugins, corePlugins, params, this.initContext.env.mode.dev, this.experimentalFeatures);
      },
      updater$: this.uptimeAppUpdater
    });
  }
  start(coreStart, pluginsStart) {
    const {
      registerExtension
    } = pluginsStart.fleet;
    (0, _kibana_services.setStartServices)(coreStart);
    registerUptimeFleetExtensions(registerExtension);
    setUptimeAppStatus(this.initContext.env.packageInfo.version, coreStart, pluginsStart, this.uptimeAppUpdater);
  }
  stop() {}
}
exports.UptimePlugin = UptimePlugin;
function registerUptimeRoutesWithNavigation(coreStart, plugins) {
  async function getUptimeSections() {
    var _coreStart$applicatio;
    if ((_coreStart$applicatio = coreStart.application.capabilities.uptime) !== null && _coreStart$applicatio !== void 0 && _coreStart$applicatio.show) {
      plugins.share.url.locators.create(new _overview.UptimeOverviewLocatorDefinition());
      return [{
        label: 'Uptime',
        sortKey: 500,
        entries: [{
          label: _i18n.i18n.translate('xpack.uptime.overview.uptimeHeading', {
            defaultMessage: 'Uptime Monitors'
          }),
          app: 'uptime',
          path: '/',
          matchFullPath: true,
          ignoreTrailingSlash: true
        }, {
          label: _i18n.i18n.translate('xpack.uptime.certificatesPage.heading', {
            defaultMessage: 'TLS Certificates'
          }),
          app: 'uptime',
          path: '/certificates',
          matchFullPath: true
        }]
      }];
    }
    return [];
  }
  plugins.observabilityShared.navigation.registerSections((0, _rxjs.from)(getUptimeSections()));
}
function registerUptimeFleetExtensions(registerExtension) {
  registerExtension({
    package: 'synthetics',
    view: 'package-policy-create',
    Component: _fleet_package.LazySyntheticsPolicyCreateExtension
  });
  registerExtension({
    package: 'synthetics',
    view: 'package-policy-edit',
    useLatestPackageVersion: true,
    Component: _fleet_package.LazySyntheticsPolicyEditExtension
  });
  registerExtension({
    package: 'synthetics',
    view: 'package-detail-assets',
    Component: _lazy_synthetics_custom_assets_extension.LazySyntheticsCustomAssetsExtension
  });
}
function setUptimeAppStatus(stackVersion, coreStart, pluginsStart, updater) {
  const isEnabled = coreStart.uiSettings.get(_public2.enableLegacyUptimeApp);
  if (isEnabled) {
    registerUptimeRoutesWithNavigation(coreStart, pluginsStart);
    registerAlertRules(coreStart, pluginsStart, stackVersion, false);
    updater.next(() => ({
      status: _coreApplicationBrowser.AppStatus.accessible
    }));
  } else {
    var _coreStart$applicatio2;
    const hasUptimePrivileges = (_coreStart$applicatio2 = coreStart.application.capabilities.uptime) === null || _coreStart$applicatio2 === void 0 ? void 0 : _coreStart$applicatio2.show;
    if (hasUptimePrivileges) {
      const indexStatusPromise = (0, _uptime_overview_fetcher.UptimeDataHelper)(coreStart).indexStatus('now-7d/d', 'now/d');
      indexStatusPromise.then(indexStatus => {
        if (indexStatus.indexExists) {
          registerUptimeRoutesWithNavigation(coreStart, pluginsStart);
          updater.next(() => ({
            status: _coreApplicationBrowser.AppStatus.accessible
          }));
          registerAlertRules(coreStart, pluginsStart, stackVersion, false);
        } else {
          updater.next(() => ({
            status: _coreApplicationBrowser.AppStatus.inaccessible
          }));
          registerAlertRules(coreStart, pluginsStart, stackVersion, true);
        }
      });
    }
  }
}
function registerAlertRules(coreStart, pluginsStart, stackVersion, isHidden = false) {
  _alert_types.uptimeAlertTypeInitializers.forEach(init => {
    const {
      observabilityRuleTypeRegistry
    } = pluginsStart.observability;
    const alertInitializer = init({
      isHidden,
      stackVersion,
      core: coreStart,
      plugins: pluginsStart
    });
    if (!pluginsStart.triggersActionsUi.ruleTypeRegistry.has(alertInitializer.id)) {
      observabilityRuleTypeRegistry.register(alertInitializer);
    }
  });
  _alert_types.legacyAlertTypeInitializers.forEach(init => {
    const alertInitializer = init({
      isHidden,
      stackVersion,
      core: coreStart,
      plugins: pluginsStart
    });
    if (!pluginsStart.triggersActionsUi.ruleTypeRegistry.has(alertInitializer.id)) {
      pluginsStart.triggersActionsUi.ruleTypeRegistry.register(alertInitializer);
    }
  });
}