"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.uiReducer = void 0;
var _reduxActions = require("redux-actions");
var _actions = require("../actions");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const initialState = {
  alertFlyoutVisible: false,
  basePath: '',
  esKuery: '',
  searchText: '',
  integrationsPopoverOpen: null,
  monitorId: ''
};
const uiReducer = exports.uiReducer = (0, _reduxActions.handleActions)({
  [String(_actions.toggleIntegrationsPopover)]: (state, action) => ({
    ...state,
    integrationsPopoverOpen: action.payload
  }),
  [String(_actions.setAlertFlyoutVisible)]: (state, action) => {
    var _action$payload;
    return {
      ...state,
      alertFlyoutVisible: (_action$payload = action.payload) !== null && _action$payload !== void 0 ? _action$payload : !state.alertFlyoutVisible
    };
  },
  [String(_actions.setBasePath)]: (state, action) => ({
    ...state,
    basePath: action.payload
  }),
  [String(_actions.setEsKueryString)]: (state, action) => ({
    ...state,
    esKuery: action.payload
  }),
  [String(_actions.setAlertFlyoutType)]: (state, action) => ({
    ...state,
    alertFlyoutType: action.payload
  }),
  [String(_actions.setSearchTextAction)]: (state, action) => ({
    ...state,
    searchText: action.payload
  }),
  [String(_actions.setSelectedMonitorId)]: (state, action) => ({
    ...state,
    monitorId: action.payload
  })
}, initialState);