"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.pingListReducer = void 0;
var _reduxActions = require("redux-actions");
var _actions = require("../actions");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const initialState = {
  pingList: {
    total: 0,
    pings: []
  },
  loading: false
};
const pingListReducer = exports.pingListReducer = (0, _reduxActions.handleActions)({
  [String(_actions.clearPings)]: state => ({
    ...state,
    ...initialState
  }),
  [String(_actions.getPings)]: state => ({
    ...state,
    loading: true
  }),
  [String(_actions.getPingsSuccess)]: (state, action) => ({
    ...state,
    pingList: {
      ...action.payload
    },
    loading: false,
    error: undefined
  }),
  [String(_actions.getPingsFail)]: (state, action) => ({
    ...state,
    error: action.payload,
    loading: false
  })
}, initialState);