"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.monitorStatusReducer = exports.initialState = void 0;
var _reduxActions = require("redux-actions");
var _actions = require("../actions");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const initialState = exports.initialState = {
  status: null,
  loading: false
};
const monitorStatusReducer = exports.monitorStatusReducer = (0, _reduxActions.handleActions)({
  [String(_actions.getMonitorStatusAction)]: (state, action) => {
    var _state$status, _state$status$monitor;
    return {
      ...state,
      // reset state if monitorId changes
      status: action.payload.monitorId === (state === null || state === void 0 ? void 0 : (_state$status = state.status) === null || _state$status === void 0 ? void 0 : (_state$status$monitor = _state$status.monitor) === null || _state$status$monitor === void 0 ? void 0 : _state$status$monitor.id) ? state.status : null,
      loading: true
    };
  },
  [String(_actions.getMonitorStatusActionSuccess)]: (state, action) => {
    var _action$payload, _state$status2;
    return {
      ...state,
      loading: false,
      // Keeping url from prev request to display, if there is no latest status
      status: {
        url: ((_action$payload = action.payload) === null || _action$payload === void 0 ? void 0 : _action$payload.url) || ((_state$status2 = state.status) === null || _state$status2 === void 0 ? void 0 : _state$status2.url),
        ...action.payload
      }
    };
  },
  [String(_actions.getMonitorStatusActionFail)]: state => ({
    ...state,
    loading: false
  })
}, initialState);