"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.dynamicSettingsReducer = void 0;
var _reduxActions = require("redux-actions");
var _dynamic_settings = require("../actions/dynamic_settings");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const initialState = {
  loading: true
};
const dynamicSettingsReducer = exports.dynamicSettingsReducer = (0, _reduxActions.handleActions)({
  [String(_dynamic_settings.getDynamicSettings)]: state => ({
    ...state,
    loading: true
  }),
  [String(_dynamic_settings.getDynamicSettingsSuccess)]: (_state, action) => ({
    loading: false,
    settings: action.payload
  }),
  [String(_dynamic_settings.getDynamicSettingsFail)]: (_state, action) => ({
    loading: false,
    loadError: action.payload
  }),
  [String(_dynamic_settings.setDynamicSettings)]: state => ({
    ...state,
    loading: true
  }),
  [String(_dynamic_settings.setDynamicSettingsSuccess)]: (_state, action) => ({
    settings: action.payload,
    saveSucceded: true,
    loading: false
  }),
  [String(_dynamic_settings.setDynamicSettingsFail)]: (state, action) => ({
    ...state,
    loading: false,
    saveSucceeded: false,
    saveError: action.payload
  })
}, initialState);