"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fetchNetworkEventsEffect = fetchNetworkEventsEffect;
var _effects = require("redux-saga/effects");
var _network_events = require("../actions/network_events");
var _network_events2 = require("../api/network_events");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function* fetchNetworkEventsEffect() {
  yield (0, _effects.takeLatest)(_network_events.getNetworkEvents, function* (action) {
    try {
      const response = yield (0, _effects.call)(_network_events2.fetchNetworkEvents, action.payload);
      yield (0, _effects.put)((0, _network_events.getNetworkEventsSuccess)({
        checkGroup: action.payload.checkGroup,
        stepIndex: action.payload.stepIndex,
        ...response
      }));
    } catch (e) {
      yield (0, _effects.put)((0, _network_events.getNetworkEventsFail)({
        checkGroup: action.payload.checkGroup,
        stepIndex: action.payload.stepIndex,
        error: e
      }));
    }
  });
}