"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSearchText = void 0;
var _react = require("react");
var _reactRedux = require("react-redux");
var _actions = require("../state/actions");
var _selectors = require("../state/selectors");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useSearchText = () => {
  const dispatch = (0, _reactRedux.useDispatch)();
  const searchText = (0, _reactRedux.useSelector)(_selectors.searchTextSelector);
  const updateSearchText = (0, _react.useCallback)(nextSearchText => dispatch((0, _actions.setSearchTextAction)(nextSearchText)), [dispatch]);
  return {
    searchText,
    updateSearchText
  };
};
exports.useSearchText = useSearchText;