"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NoItemsMessage = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _reactRedux = require("react-redux");
var labels = _interopRequireWildcard(require("./translations"));
var _hooks = require("../../../hooks");
var _selectors = require("../../../state/selectors");
var _troubleshoot_popover = require("./troubleshoot_popover");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const NoItemsMessage = ({
  loading,
  filters
}) => {
  const {
    statusFilter
  } = (0, _hooks.useGetUrlParams)();
  const {
    pingHistogram
  } = (0, _reactRedux.useSelector)(_selectors.selectPingHistogram);
  const hasPingsData = (pingHistogram === null || pingHistogram === void 0 ? void 0 : pingHistogram.histogram) && pingHistogram.histogram.length > 0;
  const clockSyncError = hasPingsData && !statusFilter ? /*#__PURE__*/_react.default.createElement(_troubleshoot_popover.TroubleshootPopover, null) : null;
  if (loading) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, " ", labels.LOADING);
  }
  if (filters) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      gutterSize: "xs"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, labels.NO_MONITOR_ITEM_SELECTED), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, clockSyncError)));
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, labels.NO_DATA_MESSAGE, clockSyncError);
};
exports.NoItemsMessage = NoItemsMessage;