"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MonitorStatusRow = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _constants = require("../../../../../../common/constants");
var _monitor_status_column = require("../columns/monitor_status_column");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MonitorStatusRow = ({
  locationNames,
  status
}) => {
  const color = status === _constants.STATUS.UP ? 'success' : 'danger';
  let checkListArray = [...locationNames];
  // If un-named location exists, move it to end
  if (locationNames.has(_constants.UNNAMED_LOCATION)) {
    checkListArray = checkListArray.filter(item => item !== _constants.UNNAMED_LOCATION);
    checkListArray.push(_constants.UNNAMED_LOCATION);
  }
  const locations = checkListArray.join(', ');
  return /*#__PURE__*/_react.default.createElement("span", null, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: color
  }, (0, _monitor_status_column.getHealthMessage)(status)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  }), /*#__PURE__*/_react.default.createElement("span", {
    "aria-label": _i18n.i18n.translate('xpack.uptime.monitorList.drawer.statusRowLocationList', {
      defaultMessage: 'A list of locations with "{status}" status when last checked.',
      values: {
        status
      }
    })
  }, locations || '--'), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  }));
};
exports.MonitorStatusRow = MonitorStatusRow;