"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.YEARS_TIME_RANGE = exports.YEARS = exports.WEEKS_TIME_RANGE = exports.WEEKS = exports.ToggleFlyoutTranslations = exports.TlsTranslations = exports.TYPE = exports.TAG = exports.SECONDS_TIME_RANGE = exports.SECONDS = exports.PORT = exports.OPEN_THE_POPOVER_TIME_RANGE_VALUE = exports.OPEN_THE_POPOVER_DOWN_COUNT = exports.MONTHS_TIME_RANGE = exports.MONTHS = exports.MINUTES_TIME_RANGE = exports.MINUTES = exports.MATCHING_MONITORS_DOWN = exports.LOCATION = exports.HOURS_TIME_RANGE = exports.HOURS = exports.ENTER_NUMBER_OF_TIME_UNITS_VALUE = exports.ENTER_NUMBER_OF_TIME_UNITS_DESCRIPTION = exports.ENTER_NUMBER_OF_TIME_UNITS = exports.ENTER_NUMBER_OF_DOWN_COUNTS = exports.ENTER_AVAILABILITY_THRESHOLD_VALUE = exports.ENTER_AVAILABILITY_THRESHOLD_INPUT_ARIA_LABEL = exports.ENTER_AVAILABILITY_THRESHOLD_DESCRIPTION = exports.ENTER_AVAILABILITY_THRESHOLD_ARIA_LABEL = exports.ENTER_AVAILABILITY_RANGE_UNITS_DESCRIPTION = exports.ENTER_AVAILABILITY_RANGE_UNITS_ARIA_LABEL = exports.ENTER_AVAILABILITY_RANGE_SELECT_HEADLINE = exports.ENTER_AVAILABILITY_RANGE_SELECT_ARIA = exports.ENTER_AVAILABILITY_RANGE_POPOVER_ARIA_LABEL = exports.ENTER_AVAILABILITY_RANGE_ENABLED = exports.ENTER_ANY_AVAILABILITY_THRESHOLD_DESCRIPTION = exports.DAYS_TIME_RANGE = exports.DAYS = exports.ANY_MONITOR_DOWN = exports.ALERT_KUERY_BAR_ARIA = exports.ADD_FILTER = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SECONDS_TIME_RANGE = exports.SECONDS_TIME_RANGE = _i18n.i18n.translate('xpack.uptime.alerts.timerangeUnitSelectable.secondsOption.ariaLabel', {
  defaultMessage: '"Seconds" time range select item'
});
const SECONDS = exports.SECONDS = _i18n.i18n.translate('xpack.uptime.alerts.monitorStatus.timerangeOption.seconds', {
  defaultMessage: 'seconds'
});
const MINUTES_TIME_RANGE = exports.MINUTES_TIME_RANGE = _i18n.i18n.translate('xpack.uptime.alerts.timerangeUnitSelectable.minutesOption.ariaLabel', {
  defaultMessage: '"Minutes" time range select item'
});
const MINUTES = exports.MINUTES = _i18n.i18n.translate('xpack.uptime.alerts.monitorStatus.timerangeOption.minutes', {
  defaultMessage: 'minutes'
});
const HOURS_TIME_RANGE = exports.HOURS_TIME_RANGE = _i18n.i18n.translate('xpack.uptime.alerts.timerangeUnitSelectable.hoursOption.ariaLabel', {
  defaultMessage: '"Hours" time range select item'
});
const HOURS = exports.HOURS = _i18n.i18n.translate('xpack.uptime.alerts.monitorStatus.timerangeOption.hours', {
  defaultMessage: 'hours'
});
const DAYS_TIME_RANGE = exports.DAYS_TIME_RANGE = _i18n.i18n.translate('xpack.uptime.alerts.timerangeUnitSelectable.daysOption.ariaLabel', {
  defaultMessage: '"Days" time range select item'
});
const DAYS = exports.DAYS = _i18n.i18n.translate('xpack.uptime.alerts.monitorStatus.timerangeOption.days', {
  defaultMessage: 'days'
});
const WEEKS_TIME_RANGE = exports.WEEKS_TIME_RANGE = _i18n.i18n.translate('xpack.uptime.alerts.timerangeUnitSelectable.weeksOption.ariaLabel', {
  defaultMessage: '"Weeks" time range select item'
});
const WEEKS = exports.WEEKS = _i18n.i18n.translate('xpack.uptime.alerts.monitorStatus.timerangeOption.weeks', {
  defaultMessage: 'weeks'
});
const MONTHS_TIME_RANGE = exports.MONTHS_TIME_RANGE = _i18n.i18n.translate('xpack.uptime.alerts.timerangeUnitSelectable.monthsOption.ariaLabel', {
  defaultMessage: '"Months" time range select item'
});
const MONTHS = exports.MONTHS = _i18n.i18n.translate('xpack.uptime.alerts.monitorStatus.timerangeOption.months', {
  defaultMessage: 'months'
});
const YEARS_TIME_RANGE = exports.YEARS_TIME_RANGE = _i18n.i18n.translate('xpack.uptime.alerts.timerangeUnitSelectable.yearsOption.ariaLabel', {
  defaultMessage: '"Years" time range select item'
});
const YEARS = exports.YEARS = _i18n.i18n.translate('xpack.uptime.alerts.monitorStatus.timerangeOption.years', {
  defaultMessage: 'years'
});
const ALERT_KUERY_BAR_ARIA = exports.ALERT_KUERY_BAR_ARIA = _i18n.i18n.translate('xpack.uptime.alerts.monitorStatus.filterBar.ariaLabel', {
  defaultMessage: 'Input that allows filtering criteria for the monitor status alert'
});
const OPEN_THE_POPOVER_DOWN_COUNT = exports.OPEN_THE_POPOVER_DOWN_COUNT = _i18n.i18n.translate('xpack.uptime.alerts.monitorStatus.numTimesExpression.ariaLabel', {
  defaultMessage: 'Open the popover for down count input'
});
const ENTER_NUMBER_OF_DOWN_COUNTS = exports.ENTER_NUMBER_OF_DOWN_COUNTS = _i18n.i18n.translate('xpack.uptime.alerts.monitorStatus.numTimesField.ariaLabel', {
  defaultMessage: 'Enter number of down counts required to trigger the alert'
});
const MATCHING_MONITORS_DOWN = exports.MATCHING_MONITORS_DOWN = _i18n.i18n.translate('xpack.uptime.alerts.monitorStatus.numTimesExpression.matchingMonitors.description', {
  defaultMessage: 'matching monitors are down >='
});
const ANY_MONITOR_DOWN = exports.ANY_MONITOR_DOWN = _i18n.i18n.translate('xpack.uptime.alerts.monitorStatus.numTimesExpression.anyMonitors.description', {
  defaultMessage: 'any monitor is down >='
});
const OPEN_THE_POPOVER_TIME_RANGE_VALUE = exports.OPEN_THE_POPOVER_TIME_RANGE_VALUE = _i18n.i18n.translate('xpack.uptime.alerts.monitorStatus.timerangeValueExpression.ariaLabel', {
  defaultMessage: 'Open the popover for time range value field'
});
const ENTER_NUMBER_OF_TIME_UNITS = exports.ENTER_NUMBER_OF_TIME_UNITS = _i18n.i18n.translate('xpack.uptime.alerts.monitorStatus.timerangeValueField.ariaLabel', {
  defaultMessage: `Enter the number of time units for the alert's range`
});
const ENTER_NUMBER_OF_TIME_UNITS_DESCRIPTION = exports.ENTER_NUMBER_OF_TIME_UNITS_DESCRIPTION = _i18n.i18n.translate('xpack.uptime.alerts.monitorStatus.timerangeValueField.expression', {
  defaultMessage: 'within'
});
const ENTER_NUMBER_OF_TIME_UNITS_VALUE = value => _i18n.i18n.translate('xpack.uptime.alerts.monitorStatus.timerangeValueField.value', {
  defaultMessage: 'last {value}',
  values: {
    value
  }
});
exports.ENTER_NUMBER_OF_TIME_UNITS_VALUE = ENTER_NUMBER_OF_TIME_UNITS_VALUE;
const ENTER_AVAILABILITY_RANGE_ENABLED = exports.ENTER_AVAILABILITY_RANGE_ENABLED = _i18n.i18n.translate('xpack.uptime.alerts.monitorStatus.availability.isEnabledCheckbox.label', {
  defaultMessage: 'Availability'
});
const ENTER_AVAILABILITY_RANGE_POPOVER_ARIA_LABEL = exports.ENTER_AVAILABILITY_RANGE_POPOVER_ARIA_LABEL = _i18n.i18n.translate('xpack.uptime.alerts.monitorStatus.availability.timerangeValueField.popover.ariaLabel', {
  defaultMessage: 'Specify availability tracking time range'
});
const ENTER_AVAILABILITY_RANGE_UNITS_ARIA_LABEL = exports.ENTER_AVAILABILITY_RANGE_UNITS_ARIA_LABEL = _i18n.i18n.translate('xpack.uptime.alerts.monitorStatus.availability.timerangeValueField.ariaLabel', {
  defaultMessage: `Enter the number of units for the alert's availability check.`
});
const ENTER_AVAILABILITY_RANGE_UNITS_DESCRIPTION = exports.ENTER_AVAILABILITY_RANGE_UNITS_DESCRIPTION = _i18n.i18n.translate('xpack.uptime.alerts.monitorStatus.availability.timerangeValueField.expression', {
  defaultMessage: 'within the last'
});
const ENTER_AVAILABILITY_THRESHOLD_ARIA_LABEL = exports.ENTER_AVAILABILITY_THRESHOLD_ARIA_LABEL = _i18n.i18n.translate('xpack.uptime.alerts.monitorStatus.availability.threshold.ariaLabel', {
  defaultMessage: 'Specify availability thresholds for this alert'
});
const ENTER_AVAILABILITY_THRESHOLD_INPUT_ARIA_LABEL = exports.ENTER_AVAILABILITY_THRESHOLD_INPUT_ARIA_LABEL = _i18n.i18n.translate('xpack.uptime.alerts.monitorStatus.availability.threshold.input.ariaLabel', {
  defaultMessage: 'Input an availability threshold to check for this alert'
});
const ENTER_AVAILABILITY_THRESHOLD_DESCRIPTION = exports.ENTER_AVAILABILITY_THRESHOLD_DESCRIPTION = _i18n.i18n.translate('xpack.uptime.alerts.monitorStatus.availability.threshold.description', {
  defaultMessage: 'matching monitors are up in',
  description: 'This fragment explains that an alert will fire for monitors matching user-specified criteria'
});
const ENTER_ANY_AVAILABILITY_THRESHOLD_DESCRIPTION = exports.ENTER_ANY_AVAILABILITY_THRESHOLD_DESCRIPTION = _i18n.i18n.translate('xpack.uptime.alerts.monitorStatus.availability.threshold.anyMonitorDescription', {
  defaultMessage: 'any monitor is up in',
  description: 'This fragment explains that an alert will fire for monitors matching user-specified criteria'
});
const ENTER_AVAILABILITY_THRESHOLD_VALUE = value => _i18n.i18n.translate('xpack.uptime.alerts.monitorStatus.availability.threshold.value', {
  defaultMessage: '< {value}% of checks',
  description: 'This fragment specifies criteria that will cause an alert to fire for uptime monitors',
  values: {
    value
  }
});
exports.ENTER_AVAILABILITY_THRESHOLD_VALUE = ENTER_AVAILABILITY_THRESHOLD_VALUE;
const ENTER_AVAILABILITY_RANGE_SELECT_ARIA = exports.ENTER_AVAILABILITY_RANGE_SELECT_ARIA = _i18n.i18n.translate('xpack.uptime.alerts.monitorStatus.availability.unit.selectable', {
  defaultMessage: 'Use this select to set the availability range units for this alert'
});
const ENTER_AVAILABILITY_RANGE_SELECT_HEADLINE = exports.ENTER_AVAILABILITY_RANGE_SELECT_HEADLINE = _i18n.i18n.translate('xpack.uptime.alerts.monitorStatus.availability.unit.headline', {
  defaultMessage: 'Select time range unit'
});
const ADD_FILTER = exports.ADD_FILTER = _i18n.i18n.translate('xpack.uptime.alerts.monitorStatus.addFilter', {
  defaultMessage: `Add filter`
});
const LOCATION = exports.LOCATION = _i18n.i18n.translate('xpack.uptime.alerts.monitorStatus.addFilter.location', {
  defaultMessage: `Location`
});
const TAG = exports.TAG = _i18n.i18n.translate('xpack.uptime.alerts.monitorStatus.addFilter.tag', {
  defaultMessage: `Tag`
});
const PORT = exports.PORT = _i18n.i18n.translate('xpack.uptime.alerts.monitorStatus.addFilter.port', {
  defaultMessage: `Port`
});
const TYPE = exports.TYPE = _i18n.i18n.translate('xpack.uptime.alerts.monitorStatus.addFilter.type', {
  defaultMessage: `Type`
});
const TlsTranslations = exports.TlsTranslations = {
  criteriaAriaLabel: _i18n.i18n.translate('xpack.uptime.alerts.tls.criteriaExpression.ariaLabel', {
    defaultMessage: 'An expression displaying the criteria for monitor that are watched by this alert'
  }),
  criteriaDescription: _i18n.i18n.translate('xpack.uptime.alerts.tls.criteriaExpression.description', {
    defaultMessage: 'when',
    description: 'The context of this `when` is in the conditional sense, like "when there are three cookies, eat them all".'
  }),
  criteriaValue: _i18n.i18n.translate('xpack.uptime.tls.criteriaExpression.value', {
    defaultMessage: 'matching monitor'
  }),
  expirationDescription: _i18n.i18n.translate('xpack.uptime.tls.expirationExpression.description', {
    defaultMessage: 'has a certificate expiring within days: '
  }),
  ageDescription: _i18n.i18n.translate('xpack.uptime.tls.ageExpression.description', {
    defaultMessage: 'or older than days: '
  })
};
const ToggleFlyoutTranslations = exports.ToggleFlyoutTranslations = {
  toggleButtonAriaLabel: _i18n.i18n.translate('xpack.uptime.alertsPopover.toggleButton.ariaLabel', {
    defaultMessage: 'Open alerts and rules context menu'
  }),
  openAlertContextPanelAriaLabel: _i18n.i18n.translate('xpack.uptime..openAlertContextPanel.ariaLabel', {
    defaultMessage: 'Open the rule context panel so you can choose a rule type'
  }),
  openAlertContextPanelLabel: _i18n.i18n.translate('xpack.uptime.openAlertContextPanel.label', {
    defaultMessage: 'Create rule'
  }),
  toggleTlsAriaLabel: _i18n.i18n.translate('xpack.uptime.toggleTlsAlertButton.ariaLabel', {
    defaultMessage: 'Open TLS rule flyout'
  }),
  toggleTlsContent: _i18n.i18n.translate('xpack.uptime.toggleTlsAlertButton.content', {
    defaultMessage: 'TLS rule'
  }),
  toggleMonitorStatusAriaLabel: _i18n.i18n.translate('xpack.uptime.toggleAlertFlyout.ariaLabel', {
    defaultMessage: 'Open add rule flyout'
  }),
  toggleMonitorStatusContent: _i18n.i18n.translate('xpack.uptime.toggleAlertButton.content', {
    defaultMessage: 'Monitor status rule'
  }),
  navigateToAlertingUIAriaLabel: _i18n.i18n.translate('xpack.uptime.navigateToAlertingUi', {
    defaultMessage: 'Leave Uptime and go to Alerting Management page'
  }),
  navigateToAlertingButtonContent: _i18n.i18n.translate('xpack.uptime..navigateToAlertingButton.content', {
    defaultMessage: 'Manage rules'
  }),
  toggleAlertFlyoutButtonLabel: _i18n.i18n.translate('xpack.uptime.alerts.createRulesPanel.title', {
    defaultMessage: 'Create rules'
  })
};