"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WaterfallFilter = exports.MIME_FILTERS = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _useDebounce = _interopRequireDefault(require("react-use/lib/useDebounce"));
var _public = require("@kbn/observability-shared-plugin/public");
var _translations = require("../../waterfall/components/translations");
var _types = require("./types");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MIME_FILTERS = exports.MIME_FILTERS = [{
  label: _types.FriendlyMimetypeLabels[_types.MimeType.XHR],
  mimeType: _types.MimeType.XHR
}, {
  label: _types.FriendlyMimetypeLabels[_types.MimeType.Html],
  mimeType: _types.MimeType.Html
}, {
  label: _types.FriendlyMimetypeLabels[_types.MimeType.Script],
  mimeType: _types.MimeType.Script
}, {
  label: _types.FriendlyMimetypeLabels[_types.MimeType.Stylesheet],
  mimeType: _types.MimeType.Stylesheet
}, {
  label: _types.FriendlyMimetypeLabels[_types.MimeType.Font],
  mimeType: _types.MimeType.Font
}, {
  label: _types.FriendlyMimetypeLabels[_types.MimeType.Media],
  mimeType: _types.MimeType.Media
}];
const WaterfallFilter = ({
  query,
  setQuery,
  activeFilters,
  setActiveFilters,
  onlyHighlighted,
  setOnlyHighlighted
}) => {
  const [value, setValue] = (0, _react.useState)(query);
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const trackMetric = (0, _public.useUiTracker)({
    app: 'uptime'
  });
  const toggleFilters = val => {
    setActiveFilters(prevState => prevState.includes(val) ? prevState.filter(filter => filter !== val) : [...prevState, val]);
  };
  (0, _useDebounce.default)(() => {
    setQuery(value);
  }, 250, [value]);

  /* reset checkbox when there is no query or active filters
   * this prevents the checkbox from being checked in a disabled state */
  (0, _react.useEffect)(() => {
    if (!(query || activeFilters.length > 0)) {
      setOnlyHighlighted(false);
    }
  }, [activeFilters.length, setOnlyHighlighted, query]);

  // indicates use of the query input box
  (0, _react.useEffect)(() => {
    if (query) {
      trackMetric({
        metric: 'waterfall_filter_input_changed',
        metricType: _public.METRIC_TYPE.CLICK
      });
    }
  }, [query, trackMetric]);

  // indicates the collapse to show only highlighted checkbox has been clicked
  (0, _react.useEffect)(() => {
    if (onlyHighlighted) {
      trackMetric({
        metric: 'waterfall_filter_collapse_checked',
        metricType: _public.METRIC_TYPE.CLICK
      });
    }
  }, [onlyHighlighted, trackMetric]);

  // indicates filters have been applied or changed
  (0, _react.useEffect)(() => {
    if (activeFilters.length > 0) {
      trackMetric({
        metric: `waterfall_filters_applied_changed`,
        metricType: _public.METRIC_TYPE.CLICK
      });
    }
  }, [activeFilters, trackMetric]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldSearch, {
    "data-test-subj": "syntheticsWaterfallFilterFieldSearch",
    fullWidth: true,
    "aria-label": _translations.FILTER_REQUESTS_LABEL,
    placeholder: _translations.FILTER_REQUESTS_LABEL,
    onChange: evt => {
      setValue(evt.target.value);
    },
    value: value
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      "data-test-subj": "observabilitySolutionWaterfallFilterButton",
      "aria-label": _translations.FILTER_POPOVER_OPEN_LABEL,
      iconType: "filter",
      onClick: () => setIsPopoverOpen(prevState => !prevState),
      color: activeFilters.length > 0 ? 'primary' : 'text',
      isSelected: activeFilters.length > 0
    }),
    isOpen: isPopoverOpen,
    closePopover: () => setIsPopoverOpen(false),
    anchorPosition: "rightCenter"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFilterGroup, null, MIME_FILTERS.map(({
    label,
    mimeType
  }) => /*#__PURE__*/_react.default.createElement(_eui.EuiFilterButton, {
    isToggle: true,
    isSelected: activeFilters.includes(mimeType),
    hasActiveFilters: activeFilters.includes(mimeType),
    onClick: () => toggleFilters(mimeType),
    key: label,
    withNext: true,
    "aria-label": `${activeFilters.includes(mimeType) ? _translations.FILTER_REMOVE_SCREENREADER_LABEL : _translations.FILTER_SCREENREADER_LABEL} ${label}`
  }, label))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCheckbox, {
    disabled: !(query || activeFilters.length > 0),
    id: "onlyHighlighted",
    label: _translations.FILTER_COLLAPSE_REQUESTS_LABEL,
    checked: onlyHighlighted,
    onChange: e => {
      setOnlyHighlighted(e.target.checked);
    }
  }))));
};
exports.WaterfallFilter = WaterfallFilter;