"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LocationAvailability = void 0;
var _react = _interopRequireDefault(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _eui = require("@elastic/eui");
var _availability_reporting = require("../availability_reporting");
var _translations = require("../translations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EuiFlexItemTags = (0, _styledComponents.default)(_eui.EuiFlexItem)`
  width: 350px;
  @media (max-width: 1042px) {
    width: 100%;
  }
`;
const LocationAvailability = ({
  monitorLocations
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiErrorBoundary, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    gutterSize: 'none',
    style: {
      flexGrow: 0
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h3", null, _translations.MonitoringFrom)))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    wrap: true,
    gutterSize: "none",
    justifyContent: "flexEnd"
  }, /*#__PURE__*/_react.default.createElement(EuiFlexItemTags, {
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_availability_reporting.LocationStatusTags, {
    locations: (monitorLocations === null || monitorLocations === void 0 ? void 0 : monitorLocations.locations) || []
  }))));
};
exports.LocationAvailability = LocationAvailability;