"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAnomalyAlert = void 0;
var _react = require("react");
var _reactRedux = require("react-redux");
var _selectors = require("../../../state/selectors");
var _contexts = require("../../../contexts");
var _hooks = require("../../../hooks");
var _alerts = require("../../../state/alerts/alerts");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useAnomalyAlert = () => {
  const {
    lastRefresh
  } = (0, _react.useContext)(_contexts.UptimeRefreshContext);
  const dispatch = (0, _reactRedux.useDispatch)();
  const monitorId = (0, _hooks.useMonitorId)();
  const {
    data: anomalyAlert
  } = (0, _reactRedux.useSelector)(_alerts.anomalyAlertSelector);
  const alertFlyoutVisible = (0, _reactRedux.useSelector)(_selectors.selectAlertFlyoutVisibility);
  (0, _react.useEffect)(() => {
    dispatch(_alerts.getAnomalyAlertAction.get({
      monitorId
    }));
  }, [monitorId, lastRefresh, dispatch, alertFlyoutVisible]);
  return anomalyAlert;
};
exports.useAnomalyAlert = useAnomalyAlert;